set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9506730';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1124',
      '14242242',
      '44022421',
      NULL,
      '22103243',
      '21304222',
      '32301400',
      '34302110',
      '42021032',
      '43211102',
      '44002304',
      '12133424',
      '03312220',
      NULL,
      '22114132',
      '44341310',
      '30043302',
      '03241434',
      '04431002',
      '22023324',
      '43200010',
      NULL,
      '43022212',
      '23103413',
      NULL,
      '44110304',
      '23114332',
      NULL,
      '00220201',
      '20340023',
      '10003400',
      '20141130',
      '14313134',
      '02313001',
      '23222333',
      '02301402',
      '42013422',
      '21004220',
      '10432114',
      '42323130',
      NULL,
      '31220102',
      '00432203',
      '01104330',
      '40034322',
      '033',
      '20',
      NULL,
      12,
      '0442204',
      1,
      47,
      2,
      NULL,
      NULL,
      3.933338,
      NULL,
      ' 2-19-1990',
      86.641134,
      50.870131,
      32.841956,
      22,
      10.297624,
      NULL,
      79,
      NULL,
      14,
      6,
      11,
      1.521617,
      13.994607,
      NULL,
      8,
      NULL,
      5,
      10,
      34,
      19,
      51,
      5,
      NULL,
      NULL,
      0,
      91.606844,
      171,
      65.755122,
      143.526799,
      65.729866,
      64.416002,
      ' 1-20-1975',
      13,
      45.274913,
      8.613005,
      18.344181,
      NULL,
      NULL,
      ' 0- 0-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      37.565306,
      1,
      43,
      11.043508,
      29.616122,
      3.993707,
      ' 8- 6-2003',
      0.706582,
      1.009485,
      143.867464,
      0,
      NULL,
      87.428745,
      0.629095,
      0.572324,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3- 9-1997',
      23,
      55,
      57,
      NULL,
      60.556771,
      70,
      87.821959,
      22.262047,
      75.888455,
      30.080696,
      54,
      10.825251,
      ' 4-20-1990',
      16.705274,
      0,
      6.165792,
      5,
      47,
      9.662988,
      6.384359,
      NULL,
      NULL,
      NULL,
      ' 4-22-1988',
      0.718112,
      7,
      18,
      11.837558,
      NULL,
      6,
      1.198746,
      NULL,
      0.030602,
      47,
      0,
      NULL,
      8,
      19,
      9,
      1,
      0.387662,
      NULL,
      ' 7- 9-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      100,
      1.908448,
      ' 8-11-1986',
      NULL,
      NULL,
      NULL,
      42.892213,
      ' 6-16-2001',
      5,
      '11-15-1980',
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      14,
      ' 7-27-2003',
      28,
      NULL,
      NULL,
      ' 2-16-1990',
      NULL,
      77.594029,
      ' 7-21-1974',
      3,
      44,
      NULL,
      NULL,
      NULL,
      63.468365,
      0,
      16.094172,
      ' 5- 7-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


