set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7613632';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2142',
      NULL,
      '14103321',
      '14403322',
      '40243420',
      '12341123',
      '11124400',
      '23033111',
      NULL,
      NULL,
      '44043314',
      NULL,
      '01020011',
      '00213402',
      '31334111',
      '23311233',
      '03404330',
      NULL,
      NULL,
      NULL,
      '24323003',
      '11042212',
      '03440300',
      '01143020',
      NULL,
      '30011430',
      NULL,
      NULL,
      NULL,
      '23314230',
      '31322423',
      '24214102',
      '44413221',
      '42401020',
      '13023421',
      '34412024',
      '14240020',
      NULL,
      '04333443',
      '22000040',
      '32104243',
      '23333213',
      '11013130',
      '31441333',
      NULL,
      '014',
      '33',
      14,
      9,
      '3013212',
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.109503,
      ' 0- 0-1976',
      ' 2- 5-1980',
      6.072823,
      82.973782,
      4.590332,
      20.621906,
      34.180906,
      22.964931,
      45,
      NULL,
      27,
      13,
      NULL,
      11.183754,
      35,
      2.968019,
      20.844028,
      13,
      28,
      3,
      20.719713,
      21.380728,
      66,
      8.611670,
      10,
      NULL,
      1,
      NULL,
      249.134154,
      61.126784,
      36.779966,
      26,
      201.719463,
      NULL,
      1.092352,
      NULL,
      NULL,
      9.731943,
      190,
      216.753472,
      ' 5- 4-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      28,
      NULL,
      18.255644,
      3.832342,
      23,
      4,
      ' 5- 8-1981',
      0.278443,
      1,
      2,
      1,
      NULL,
      135,
      0,
      NULL,
      118,
      NULL,
      NULL,
      NULL,
      '10-27-1999',
      1.780495,
      113.380654,
      NULL,
      NULL,
      NULL,
      24,
      82,
      71,
      46,
      115.371997,
      NULL,
      NULL,
      ' 3-26-1985',
      6.575846,
      9.793131,
      26.827917,
      2,
      21.006234,
      114,
      10,
      '10-12-1993',
      0.936769,
      9,
      NULL,
      4,
      NULL,
      14.547333,
      NULL,
      NULL,
      6.347544,
      NULL,
      9,
      0.641970,
      7,
      NULL,
      13.543016,
      3,
      NULL,
      1.105343,
      4,
      2,
      0,
      ' 6-22-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11.360046,
      ' 3-20-1998',
      NULL,
      NULL,
      NULL,
      53.869332,
      ' 8- 3-1990',
      42.836683,
      ' 1- 8-1986',
      2,
      8.296696,
      ' 8-26-1997',
      1,
      59,
      ' 3-24-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      14,
      '10-17-1999',
      55,
      3,
      10.721510,
      ' 7-24-2000',
      NULL,
      23.281256,
      ' 2- 4-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


