set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9637950';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4021',
      '11043443',
      '31000433',
      '34021311',
      '41001432',
      '44021143',
      '43432013',
      '01243201',
      '03422433',
      '43120033',
      NULL,
      '12003034',
      '42234142',
      '22340004',
      NULL,
      '04344444',
      '30144123',
      NULL,
      '13334244',
      '14313200',
      NULL,
      '44304130',
      '43232102',
      '04242321',
      '12001112',
      '20014122',
      '22344042',
      '43141134',
      '04102333',
      '22223213',
      NULL,
      '44310130',
      NULL,
      '13341111',
      '43442122',
      '44034402',
      '04131101',
      '20414033',
      '11104210',
      '13310234',
      '22003011',
      '34310313',
      '41420410',
      NULL,
      '42222021',
      '013',
      '13',
      19,
      8.042568,
      '4114231',
      2,
      NULL,
      0,
      NULL,
      '020123',
      2.882623,
      NULL,
      ' 6-18-1975',
      NULL,
      NULL,
      29.917872,
      12,
      2.728737,
      NULL,
      NULL,
      26.964559,
      22.306546,
      1.593434,
      5.322840,
      19.871303,
      7.241549,
      14.911402,
      31.803220,
      NULL,
      2.901424,
      NULL,
      47,
      16.652600,
      47.448594,
      7,
      27,
      NULL,
      0.519161,
      72.503425,
      NULL,
      43.138265,
      NULL,
      242,
      11.404506,
      '10- 3-1974',
      8,
      37.814125,
      NULL,
      NULL,
      NULL,
      167.956638,
      '11- 9-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      49.571694,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      0,
      1,
      183,
      2.869898,
      5,
      5,
      NULL,
      3,
      62.878193,
      NULL,
      NULL,
      NULL,
      ' 5-24-1995',
      15,
      7.142864,
      2.476086,
      3.829087,
      85,
      1.602542,
      20.089594,
      NULL,
      25.207927,
      NULL,
      39.490919,
      43,
      ' 4- 6-1979',
      1,
      28.559163,
      36,
      29.282942,
      NULL,
      NULL,
      NULL,
      ' 9-28-1976',
      26.394798,
      7,
      ' 5-14-2002',
      10,
      6.185795,
      NULL,
      NULL,
      NULL,
      2.333403,
      1,
      NULL,
      NULL,
      34.863826,
      3,
      5.610049,
      23.804173,
      2.015529,
      0.123504,
      2.967661,
      1.100609,
      0.385110,
      ' 2-20-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      159.027674,
      NULL,
      '10-18-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-12-1977',
      1.269757,
      14.997714,
      ' 6-20-1981',
      108.663962,
      NULL,
      ' 3-29-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      12.945317,
      ' 9-29-1991',
      1,
      9.101664,
      29.575568,
      ' 5-25-1986',
      1.967253,
      62.865483,
      NULL,
      13,
      0.518733,
      NULL,
      NULL,
      ' 7-22-1988',
      66.400809,
      1.648930,
      85.880568,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


