set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9637950';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4023',
      '44311204',
      NULL,
      '10424123',
      '22422134',
      '04040104',
      '24113443',
      '10402434',
      '02100104',
      '14440140',
      '40144013',
      '43222114',
      '01243240',
      '20220414',
      '04233021',
      NULL,
      '00230424',
      '20414400',
      '20331000',
      '20033022',
      '11223444',
      '12313102',
      '32311101',
      '30214223',
      NULL,
      '01033130',
      '32333121',
      NULL,
      NULL,
      '31030123',
      '31031312',
      '23302044',
      NULL,
      '23432011',
      NULL,
      NULL,
      '10104201',
      '00404120',
      '14221111',
      NULL,
      '44023420',
      '13402002',
      '31124202',
      '23422444',
      NULL,
      '131',
      '20',
      12,
      NULL,
      '0300311',
      NULL,
      25.186626,
      2,
      NULL,
      '420313',
      4,
      ' 1-19-1996',
      ' 6-26-2000',
      76,
      NULL,
      22,
      21.572313,
      28,
      NULL,
      101,
      22.271285,
      5.921961,
      6,
      42.254960,
      4.513671,
      48.432357,
      27,
      14,
      NULL,
      NULL,
      4.972599,
      20.458844,
      21.293036,
      37,
      1,
      86,
      22.631784,
      0,
      11,
      6,
      82,
      NULL,
      90,
      NULL,
      ' 2-27-1974',
      NULL,
      18,
      15,
      16.156828,
      161.054584,
      247,
      ' 5- 4-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      110,
      11,
      8,
      10.428140,
      4,
      2,
      ' 3- 3-1999',
      0,
      1,
      161,
      1.384410,
      NULL,
      31,
      0,
      1,
      14.283503,
      NULL,
      NULL,
      NULL,
      ' 3-14-1998',
      87.978925,
      24,
      NULL,
      97.277142,
      11.167529,
      86,
      83,
      8,
      14,
      2,
      87,
      82,
      ' 5- 6-2001',
      15,
      26,
      19.654923,
      94,
      NULL,
      NULL,
      0.797389,
      ' 1-27-1989',
      0,
      NULL,
      '10- 4-1999',
      6,
      9,
      1.077274,
      18.735160,
      13.618978,
      4,
      0,
      3,
      0,
      NULL,
      0,
      6,
      12.252787,
      17.584430,
      7,
      2,
      0,
      0.497900,
      ' 8- 6-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      100.156762,
      3.495638,
      '10- 9-1993',
      NULL,
      NULL,
      NULL,
      12.878709,
      ' 9-24-1974',
      12,
      ' 2- 3-1982',
      7,
      17,
      ' 8-26-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      1.542839,
      ' 7- 9-1984',
      13,
      49,
      39.990297,
      NULL,
      0.608568,
      89,
      ' 0-16-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


