set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9983950';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      NULL,
      '4',
      '2',
      '4',
      NULL,
      '2',
      '1',
      '4',
      '0',
      '2',
      '3',
      NULL,
      NULL,
      '1',
      '3',
      '4',
      '0',
      '0',
      NULL,
      '3',
      '3',
      '4',
      '3',
      '',
      '0',
      '',
      '2',
      NULL,
      '1',
      '3',
      '4',
      '',
      '',
      '1',
      NULL,
      '3',
      '1',
      '0',
      '0',
      '0',
      '0',
      NULL,
      '2',
      '2',
      '120',
      '03231432',
      NULL,
      NULL,
      '2133132',
      3.070594,
      0.757018,
      NULL,
      0,
      NULL,
      5.785101,
      '10- 0-1975',
      NULL,
      51,
      56,
      3,
      NULL,
      21.492113,
      20.585517,
      NULL,
      31.094082,
      18.040678,
      4.864841,
      52.207446,
      4.523267,
      NULL,
      20,
      21,
      13.548173,
      27.246277,
      2,
      NULL,
      18.946437,
      9.297596,
      NULL,
      80.318601,
      10.708823,
      NULL,
      26,
      125.264050,
      23.962896,
      NULL,
      NULL,
      85,
      ' 4-18-1999',
      NULL,
      69.888388,
      27.580749,
      NULL,
      82.592601,
      230,
      ' 1-11-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      53.099584,
      NULL,
      9.294500,
      2.444560,
      5,
      NULL,
      ' 9-16-1988',
      NULL,
      0,
      236.155966,
      1.729427,
      0.067298,
      82,
      0.639615,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-26-1993',
      84,
      35,
      53,
      95,
      93.916152,
      31,
      NULL,
      64,
      NULL,
      37.350086,
      95,
      NULL,
      ' 9-12-1996',
      1.810516,
      41.112893,
      32.329473,
      29.214922,
      125,
      171.811620,
      7.733229,
      ' 9- 8-1989',
      NULL,
      23,
      ' 0-12-1986',
      NULL,
      17.907619,
      19,
      7,
      1.990674,
      NULL,
      NULL,
      NULL,
      1,
      71.064410,
      1.331047,
      1.892396,
      15.219497,
      8,
      0,
      1,
      2.573592,
      1.178779,
      ' 3-20-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      45,
      NULL,
      23,
      NULL,
      14.609667,
      14,
      ' 8-23-2000',
      114.931549,
      20.380174,
      ' 9- 4-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      18,
      NULL,
      NULL,
      59.807364,
      25.176733,
      NULL,
      0.740978,
      50.324471,
      ' 8-22-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


