set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7226003';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '10240330',
      '23344342',
      '24341320',
      '13413242',
      '04302041',
      NULL,
      '42331024',
      '13431012',
      NULL,
      NULL,
      '31422421',
      '01344220',
      '34100011',
      '00420331',
      '03002121',
      '03101422',
      '24300023',
      '00044213',
      '22114021',
      '20023004',
      NULL,
      '30341113',
      '22421131',
      NULL,
      '44443423',
      '10224121',
      '01441313',
      '33004203',
      '10124431',
      '30201320',
      NULL,
      '01130401',
      '02404302',
      '32302444',
      '44103404',
      '44301121',
      NULL,
      NULL,
      '02242111',
      '40033134',
      '33041432',
      NULL,
      '30143034',
      '32121223',
      '220',
      '23',
      NULL,
      NULL,
      '4032334',
      NULL,
      1.206369,
      NULL,
      NULL,
      '412320',
      NULL,
      ' 6- 9-1977',
      ' 6-27-1978',
      100.744026,
      NULL,
      23,
      4,
      NULL,
      11,
      41.790046,
      2.871578,
      NULL,
      6.954833,
      NULL,
      3,
      16,
      7,
      3,
      12.883812,
      0.360046,
      1.005245,
      NULL,
      25.346410,
      53.924085,
      13.693565,
      9,
      NULL,
      3,
      NULL,
      179.337759,
      81.682674,
      182,
      90,
      219.340771,
      ' 2- 5-1975',
      23,
      NULL,
      18,
      NULL,
      21.207670,
      11,
      ' 3- 9-1985',
      1.876959,
      NULL,
      1.185814,
      2,
      4.048129,
      0.543858,
      1.449959,
      0.843091,
      0.087239,
      NULL,
      1.843799,
      0,
      1,
      2,
      1.170141,
      0.473762,
      0,
      NULL,
      NULL,
      0.516247,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-11-2001',
      40.264974,
      0.748099,
      7,
      1,
      0,
      9,
      ' 8-12-1996',
      1.425234,
      0,
      83.439511,
      NULL,
      NULL,
      6,
      0,
      3.230127,
      64.686292,
      NULL,
      NULL,
      NULL,
      ' 4-25-1995',
      NULL,
      41,
      73,
      66.930581,
      87,
      34.011437,
      23.839551,
      98,
      74,
      NULL,
      NULL,
      74.809619,
      ' 1-12-1993',
      22.616079,
      26.070989,
      NULL,
      57,
      16,
      82.878682,
      6.614835,
      ' 1-20-1981',
      17,
      10.351977,
      ' 4-24-2001',
      14.612603,
      14,
      10.762338,
      9,
      18.842235,
      NULL,
      1,
      9,
      0,
      59.032660,
      5,
      6.592454,
      13.272580,
      20.016498,
      0,
      1.672355,
      1,
      2.727482,
      '10- 7-2002',
      3,
      3,
      5,
      ' 0-25-1998',
      NULL,
      2.578073,
      ' 0- 8-2001',
      NULL,
      NULL,
      NULL,
      55.252876,
      ' 8- 5-1977',
      17.791046,
      NULL,
      0,
      11,
      '11-18-1974',
      116.111105,
      28,
      ' 9-24-1996',
      NULL,
      9,
      ' 0- 7-1974',
      NULL,
      0.794458,
      NULL,
      1,
      3,
      NULL,
      ' 0- 9-1986',
      40.725700,
      NULL,
      65.811024,
      ' 3-16-1985',
      NULL,
      7,
      NULL,
      NULL,
      47.223595,
      12,
      0.690124,
      NULL,
      24.974926,
      3,
      49,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15);
commit;
end;
/


