set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7226003';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2240',
      '43031132',
      '40310241',
      NULL,
      '01004202',
      '30421002',
      NULL,
      '10233141',
      '32441144',
      '02014413',
      NULL,
      NULL,
      NULL,
      NULL,
      '23433322',
      '14023011',
      '10141023',
      '41222421',
      '23411234',
      '44113210',
      '04342430',
      '22312233',
      '04423002',
      '03432414',
      '10302132',
      NULL,
      '33341213',
      '20210330',
      '30013323',
      '43202103',
      '32242034',
      '03303143',
      '42220144',
      '33202130',
      '21121313',
      '40241122',
      '14102420',
      '42142002',
      NULL,
      '31021003',
      '20441042',
      '43241412',
      NULL,
      NULL,
      '33130120',
      '124',
      '41',
      NULL,
      6.569312,
      NULL,
      3.817634,
      54,
      0,
      NULL,
      '021113',
      5.351548,
      ' 0-14-1978',
      ' 4- 3-2003',
      17.942062,
      59.262483,
      NULL,
      6,
      12,
      17,
      68,
      0,
      NULL,
      5,
      10.733216,
      16.245913,
      NULL,
      7.279161,
      15,
      2.970160,
      25,
      14,
      57.615419,
      30.269911,
      24.774773,
      NULL,
      150.407485,
      4.283600,
      NULL,
      8.250149,
      91,
      121,
      187.822044,
      51,
      169.578062,
      ' 3-25-2003',
      NULL,
      NULL,
      33,
      NULL,
      144.257827,
      NULL,
      ' 8- 0-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      44,
      2.061213,
      3.664771,
      1,
      NULL,
      9,
      ' 7- 8-2002',
      NULL,
      2,
      124,
      0,
      NULL,
      0.039450,
      1.853015,
      2.134773,
      37.614169,
      NULL,
      NULL,
      NULL,
      ' 9- 4-1985',
      50.033688,
      60,
      83,
      71,
      18.901054,
      74.094650,
      NULL,
      84.534855,
      70.227072,
      85.933829,
      70,
      2,
      ' 2-19-2002',
      27,
      22.371865,
      17,
      2.906631,
      70.351587,
      55.431380,
      12,
      ' 2-12-1997',
      19.173885,
      26,
      ' 8-25-1987',
      1,
      3,
      1,
      17.950626,
      6.028725,
      4.890774,
      0,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1.889673,
      8.652475,
      NULL,
      0,
      NULL,
      0.217939,
      ' 8-20-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.571971,
      NULL,
      NULL,
      NULL,
      NULL,
      1.077358,
      NULL,
      NULL,
      ' 5-19-1993',
      1.492942,
      NULL,
      ' 4-10-1987',
      131.198202,
      127,
      ' 0-15-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      12.259075,
      NULL,
      52.299999,
      NULL,
      13,
      '11-19-1986',
      NULL,
      89.749707,
      ' 4- 9-1989',
      7,
      40.437679,
      18,
      46.578721,
      ' 0- 0-1982',
      NULL,
      1.818227,
      12.188819,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


