set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9430628';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '24330043',
      '23304042',
      NULL,
      NULL,
      '43234403',
      NULL,
      '11340231',
      '32222300',
      '42224400',
      '23412101',
      NULL,
      NULL,
      NULL,
      '34342000',
      '33334231',
      '11112424',
      NULL,
      '41032230',
      '20130303',
      '42104140',
      '21401243',
      '13111030',
      '13144024',
      '20014342',
      NULL,
      '33020012',
      '30214112',
      '40441422',
      '00102041',
      '31340132',
      '11133203',
      NULL,
      '01140221',
      '13012401',
      '44430340',
      '11424210',
      '23421204',
      '31334202',
      '20210043',
      '34004122',
      '41102024',
      '23421044',
      '20002410',
      '04304424',
      '102',
      '43',
      NULL,
      NULL,
      '3401330',
      1.419607,
      0.099594,
      2,
      NULL,
      '033434',
      4.849752,
      ' 3- 8-1977',
      NULL,
      41,
      NULL,
      NULL,
      1,
      15.989769,
      2.604626,
      89,
      NULL,
      11,
      7.153235,
      7,
      8,
      NULL,
      11,
      23,
      NULL,
      2.216868,
      10,
      55,
      13,
      32,
      NULL,
      30,
      7,
      1,
      29,
      28.175105,
      56.976844,
      NULL,
      148.544956,
      118.164226,
      ' 6-20-1993',
      26,
      15.218039,
      11,
      19.659736,
      5.665039,
      191.936779,
      ' 2-18-1981',
      0.795210,
      NULL,
      0.532381,
      NULL,
      6.267757,
      2.235294,
      4.363771,
      1.625686,
      0,
      1,
      3.968402,
      0.324626,
      1,
      0,
      1,
      0,
      1.696876,
      0.772851,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-26-1984',
      NULL,
      22,
      47,
      NULL,
      38.673002,
      NULL,
      ' 2- 5-1982',
      1.913693,
      1,
      18,
      NULL,
      1,
      36.925406,
      3,
      1,
      24.576202,
      NULL,
      NULL,
      NULL,
      ' 1-15-1999',
      48.599118,
      99,
      61,
      56.177386,
      94,
      58.865808,
      67.278810,
      NULL,
      15,
      NULL,
      76.510800,
      72.446525,
      NULL,
      12.759298,
      0.620941,
      6.904698,
      41.524087,
      NULL,
      1.369207,
      7.320127,
      ' 5-12-1979',
      4.203584,
      NULL,
      ' 3- 4-1993',
      NULL,
      13,
      6.719005,
      13,
      14.405622,
      NULL,
      3,
      4,
      1,
      4.313805,
      0,
      NULL,
      1,
      10.123456,
      NULL,
      16.337671,
      NULL,
      0.730114,
      ' 0- 3-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      93.062991,
      27,
      ' 6- 1-1986',
      NULL,
      NULL,
      NULL,
      29.189445,
      NULL,
      2,
      '11- 6-1995',
      9,
      8,
      '10-17-1986',
      NULL,
      NULL,
      NULL,
      9.139349,
      8,
      ' 7-11-1980',
      NULL,
      NULL,
      NULL,
      2,
      0,
      6.730587,
      NULL,
      38.293023,
      NULL,
      2.612690,
      NULL,
      0,
      245.251518,
      ' 1-12-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


