set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9209216';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '1',
      '3',
      '3',
      '0',
      '2',
      NULL,
      '2',
      NULL,
      '2',
      '2',
      '2',
      '3',
      NULL,
      '3',
      '3',
      '3',
      '3',
      '0',
      '1',
      '4',
      NULL,
      '0',
      '3',
      NULL,
      '4',
      '',
      NULL,
      '3',
      NULL,
      NULL,
      '3',
      NULL,
      '',
      '2',
      '4',
      NULL,
      NULL,
      '2',
      '4',
      '3',
      NULL,
      '2',
      '0',
      NULL,
      '022',
      NULL,
      35,
      36,
      '3230321',
      2,
      1.431472,
      0,
      NULL,
      '124013',
      3,
      ' 8-26-2002',
      ' 0- 2-1995',
      6,
      68.650970,
      NULL,
      4.141281,
      15.207737,
      4.612444,
      34.022653,
      5,
      4,
      7.762695,
      NULL,
      5,
      NULL,
      15.135946,
      12,
      5,
      2,
      7,
      53,
      11,
      28,
      13,
      17,
      2,
      1.543526,
      NULL,
      61.587329,
      76.950750,
      49.628033,
      62.027635,
      140.292627,
      '10- 4-1992',
      19,
      32.406953,
      NULL,
      21,
      NULL,
      161,
      '11-18-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      59,
      8,
      4.363796,
      11,
      NULL,
      1,
      '10-17-1983',
      0,
      NULL,
      NULL,
      0.450500,
      0.577193,
      90.223612,
      0,
      1.549210,
      75,
      NULL,
      NULL,
      NULL,
      ' 4- 5-1997',
      69.185797,
      NULL,
      109,
      24,
      90,
      46,
      99.945714,
      3.551015,
      77.109570,
      88,
      54,
      NULL,
      ' 9- 2-1989',
      NULL,
      NULL,
      12,
      31.039926,
      41,
      6.735984,
      3,
      ' 9-21-1991',
      4.142896,
      4.412959,
      NULL,
      3.640894,
      9.334923,
      3,
      8.909236,
      11,
      1,
      3,
      1.201968,
      1,
      NULL,
      1.659132,
      1.248736,
      6.961726,
      22,
      NULL,
      2,
      NULL,
      0,
      ' 5- 7-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      23,
      ' 2- 3-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      19,
      ' 7-23-1976',
      4.474808,
      12,
      ' 0-13-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      18.295843,
      NULL,
      23.788067,
      14.897034,
      13,
      ' 9-16-1986',
      2,
      NULL,
      NULL,
      2,
      27,
      11.643715,
      NULL,
      ' 4-27-1983',
      33.903650,
      0,
      NULL,
      ' 6-23-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


