set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9422880';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2033',
      '12444111',
      '32442111',
      '13112404',
      NULL,
      '13001244',
      '33344411',
      NULL,
      '03134431',
      NULL,
      '44334333',
      NULL,
      NULL,
      '11442301',
      '24444143',
      NULL,
      '02144022',
      '44220024',
      '20023044',
      NULL,
      '30234014',
      '32304430',
      '20401120',
      NULL,
      NULL,
      '12301112',
      '01043301',
      '20420340',
      '31440330',
      '13102333',
      '24022223',
      '20103012',
      '01031333',
      NULL,
      '20403101',
      NULL,
      '01231124',
      '14142042',
      NULL,
      '31211211',
      '42042223',
      '03240220',
      '22443020',
      '44104214',
      '02221313',
      '401',
      NULL,
      NULL,
      NULL,
      '4243444',
      3.014912,
      1.490896,
      2,
      NULL,
      NULL,
      5,
      ' 4- 9-1990',
      ' 5- 7-1996',
      3.085658,
      NULL,
      19,
      4.455549,
      NULL,
      9,
      36,
      4.813482,
      11,
      14,
      46.057528,
      7,
      10.184589,
      3,
      NULL,
      2.707225,
      NULL,
      3.300355,
      67,
      10,
      NULL,
      19,
      NULL,
      NULL,
      NULL,
      64.335895,
      42.870437,
      NULL,
      NULL,
      NULL,
      93,
      NULL,
      55,
      51,
      NULL,
      21.409790,
      NULL,
      150,
      '10-12-2001',
      NULL,
      NULL,
      5.332781,
      1,
      5.025179,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.308815,
      0,
      NULL,
      1,
      1.799615,
      1.267527,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      99,
      15.655950,
      1.613228,
      0,
      NULL,
      9,
      ' 2-10-1997',
      1,
      0.609555,
      5,
      0.678707,
      2,
      82,
      0.859297,
      1,
      53.240333,
      NULL,
      NULL,
      NULL,
      ' 0-23-1979',
      17.856723,
      96,
      103.716652,
      119,
      7,
      5,
      80.795891,
      40.747947,
      45,
      103,
      49,
      44.671582,
      ' 2-28-1994',
      5,
      4,
      17.400827,
      57,
      NULL,
      NULL,
      8.554431,
      '10-18-1988',
      NULL,
      15,
      ' 6-15-1994',
      0.098065,
      15.223590,
      16,
      8,
      NULL,
      11.862613,
      0.531202,
      NULL,
      0,
      79.374109,
      0.707786,
      3.758915,
      NULL,
      NULL,
      1.827820,
      0.147793,
      NULL,
      0.362588,
      ' 3- 7-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      1.804374,
      3.972881,
      ' 6- 8-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-21-2000',
      28,
      ' 3- 1-1990',
      NULL,
      11.353034,
      ' 9-13-1985',
      90,
      NULL,
      ' 0- 1-1976',
      11,
      2.299766,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      4,
      NULL,
      53,
      42,
      49,
      ' 6- 9-1980',
      0,
      8.182197,
      '11- 5-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


