set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9217062';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      '20322314',
      '20004022',
      '31110213',
      '11201442',
      '02040123',
      '02430342',
      '21233132',
      '12432200',
      '20031333',
      '20404021',
      '24410402',
      '43032003',
      NULL,
      '01404442',
      '42341400',
      '01402100',
      '21110132',
      '20321424',
      '01043212',
      NULL,
      '04204334',
      '32313012',
      '04203021',
      '23320402',
      '12023322',
      '42032120',
      NULL,
      NULL,
      '23332421',
      '43044440',
      '21030322',
      '33031001',
      '33420121',
      NULL,
      '14423140',
      NULL,
      '40003244',
      '44010201',
      NULL,
      NULL,
      NULL,
      '43112041',
      '44012041',
      '334',
      '40',
      NULL,
      NULL,
      '2434332',
      3.822847,
      NULL,
      1,
      NULL,
      '334041',
      1.285084,
      NULL,
      NULL,
      35.319967,
      NULL,
      40,
      6.556842,
      11.437982,
      24,
      83.221344,
      3,
      24,
      16.931724,
      39.584918,
      NULL,
      44,
      19,
      29,
      3,
      6,
      5,
      0.818943,
      5.515855,
      77.153682,
      22.486377,
      NULL,
      1.276073,
      1,
      79.937907,
      140.244223,
      37.374226,
      NULL,
      219,
      39,
      '10-13-1984',
      53.141608,
      25,
      17.799356,
      30,
      49.725272,
      NULL,
      ' 7- 6-1986',
      0.761815,
      0,
      1.114536,
      2,
      0.283764,
      NULL,
      4,
      3.745540,
      NULL,
      NULL,
      3,
      1.661870,
      0.112410,
      1.047809,
      1.903918,
      1.019642,
      1.013002,
      1.301455,
      NULL,
      0.930760,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2- 9-1997',
      85.464668,
      14.105692,
      2.387657,
      6,
      11.982432,
      7,
      ' 9- 4-2002',
      NULL,
      NULL,
      23.037683,
      0.043899,
      1,
      14,
      1.773576,
      1.862161,
      65,
      1.512313,
      1,
      17.850209,
      ' 4-13-1988',
      58,
      35.446634,
      NULL,
      49.114106,
      41.036284,
      16.667473,
      NULL,
      5.851157,
      41.986936,
      40.394778,
      45,
      21,
      NULL,
      14,
      29.320896,
      25,
      26,
      NULL,
      NULL,
      3.347260,
      '10-15-1999',
      7.565495,
      2,
      ' 5-28-1996',
      7.232521,
      NULL,
      16.110773,
      14.515467,
      19,
      4,
      1.909801,
      13.318381,
      1,
      NULL,
      0,
      NULL,
      16.220277,
      31,
      0.685044,
      0.593746,
      3,
      1,
      ' 0-25-1983',
      3,
      4.598838,
      0.274234,
      '10- 6-1986',
      181,
      NULL,
      ' 0-25-1990',
      NULL,
      NULL,
      NULL,
      10,
      ' 6-10-1974',
      44.509472,
      ' 6-29-1992',
      8.827905,
      11,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.678700,
      NULL,
      NULL,
      1.553085,
      '11-14-1983',
      1,
      2,
      19.290928,
      ' 9-26-1987',
      21.110379,
      31.258780,
      24,
      NULL,
      1.768258,
      59.950771,
      ' 5-16-1994',
      6.440761,
      NULL,
      15,
      NULL,
      ' 5- 2-2002',
      2,
      1.769929,
      47.662874,
      '10-29-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.050512);
commit;
end;
/


