set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9217062';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1213',
      '34440344',
      '41210402',
      '24333002',
      '12223114',
      '20304330',
      '41130420',
      '40124103',
      '31420303',
      '40400324',
      '00041200',
      '14430020',
      '14203204',
      '43400441',
      '11434330',
      '03341342',
      '14230244',
      '41230013',
      '43421113',
      '04314441',
      '20114302',
      '23220242',
      NULL,
      '11401343',
      '31404303',
      '00104043',
      '44013000',
      '13432110',
      '21303030',
      '44240012',
      '30204024',
      '14122323',
      NULL,
      '21113411',
      '21001000',
      '04334211',
      NULL,
      '14124313',
      '23111103',
      NULL,
      '20431343',
      '12313030',
      '04340433',
      NULL,
      '02141241',
      '104',
      '44',
      NULL,
      NULL,
      '4100243',
      0.551047,
      NULL,
      0,
      NULL,
      '103323',
      0.572162,
      ' 0-16-1981',
      ' 8-21-1998',
      64.772786,
      NULL,
      11,
      6,
      4.358753,
      10,
      67.392781,
      11,
      18.109745,
      21,
      21.020970,
      10.310187,
      8.632631,
      NULL,
      10,
      8,
      NULL,
      11,
      3.773884,
      29,
      8,
      9.565160,
      72.682304,
      NULL,
      1,
      46.303829,
      30,
      48,
      165,
      NULL,
      8.478871,
      ' 6- 8-1975',
      55,
      26,
      10.384850,
      25,
      204.773513,
      NULL,
      ' 5- 2-1995',
      5,
      3,
      1,
      0,
      0,
      0,
      5.378864,
      0,
      0,
      NULL,
      0.987616,
      0,
      NULL,
      1.794320,
      0,
      0.962541,
      0,
      1.661580,
      1.143203,
      1.878940,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-21-1981',
      82.669582,
      NULL,
      NULL,
      0,
      1.829767,
      NULL,
      ' 8-10-1999',
      0.957423,
      NULL,
      172.890540,
      1,
      1.455877,
      47,
      0,
      2.895654,
      48.779476,
      NULL,
      NULL,
      NULL,
      NULL,
      19,
      51.720884,
      0,
      36,
      16,
      NULL,
      27,
      NULL,
      12.920719,
      61.790881,
      13.151269,
      6,
      '11- 9-1987',
      5.682562,
      11.639668,
      10,
      40,
      18.678476,
      23,
      1,
      ' 5-26-1996',
      15,
      1.878932,
      NULL,
      NULL,
      8,
      4,
      8,
      11,
      0.669858,
      NULL,
      NULL,
      0.456268,
      NULL,
      0.235780,
      3,
      NULL,
      13.333481,
      0.563165,
      3,
      1,
      4.022871,
      '10-29-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 9- 1-1984',
      NULL,
      NULL,
      NULL,
      33.801555,
      ' 4-12-1984',
      26.942292,
      ' 0-27-1980',
      6,
      13,
      ' 7- 4-1978',
      NULL,
      NULL,
      NULL,
      0.743866,
      0.455701,
      ' 4-15-1983',
      NULL,
      NULL,
      NULL,
      0,
      2,
      25,
      ' 4-19-1985',
      2,
      17,
      7,
      ' 3-16-2002',
      3.446591,
      22,
      '10-11-1983',
      2.907557,
      34.549281,
      NULL,
      38,
      ' 2-26-2001',
      54,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


