set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9217062';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '4',
      '0',
      '0',
      '2',
      '2',
      '0',
      NULL,
      '3',
      '4',
      '2',
      '1',
      '4',
      NULL,
      '0',
      '0',
      '4',
      '3',
      '3',
      '4',
      '2',
      '4',
      NULL,
      '0',
      '',
      '3',
      '',
      NULL,
      '4',
      '2',
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '2',
      '3',
      '0',
      '0',
      '2',
      '1',
      '3',
      '2',
      NULL,
      '3',
      '330',
      '40030424',
      NULL,
      51,
      '0202234',
      2.446982,
      49.013806,
      0,
      NULL,
      '143302',
      3.254244,
      ' 0-11-1990',
      ' 6- 1-1982',
      55.956569,
      NULL,
      38,
      21,
      7.277772,
      2,
      59.559950,
      NULL,
      19.821493,
      7,
      31,
      18,
      28,
      7,
      16.630838,
      2,
      NULL,
      14.030072,
      50.690170,
      15,
      6,
      11.360222,
      NULL,
      9,
      3.272437,
      43.134016,
      NULL,
      30.661742,
      46,
      41,
      123,
      ' 6-26-1993',
      50.311905,
      60,
      1,
      28.048785,
      NULL,
      148.840372,
      ' 9-22-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      30,
      1.237666,
      4,
      6,
      5,
      NULL,
      NULL,
      0.941426,
      1,
      NULL,
      1,
      0.196508,
      10.595887,
      1.529857,
      0,
      64,
      NULL,
      NULL,
      NULL,
      ' 8-12-2003',
      84.836461,
      NULL,
      32,
      NULL,
      NULL,
      NULL,
      30.786594,
      0,
      45.851083,
      NULL,
      29,
      27,
      ' 2- 7-1992',
      14.585071,
      NULL,
      23.585600,
      71.192531,
      NULL,
      127.998498,
      5.295262,
      ' 1- 9-1984',
      4,
      2.744583,
      ' 3-29-1984',
      12.723399,
      1,
      7,
      9,
      16.251371,
      1.356640,
      NULL,
      15,
      NULL,
      42,
      5.490527,
      0.435504,
      2.337609,
      10,
      3.364971,
      3.590133,
      0,
      0,
      ' 7-21-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      ' 1- 1-1998',
      NULL,
      NULL,
      NULL,
      24,
      ' 2-10-1996',
      2.468251,
      ' 0-19-1987',
      5,
      15.483413,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      15.783182,
      ' 1-19-1994',
      49,
      NULL,
      19.379746,
      ' 9-11-1996',
      NULL,
      15.867019,
      ' 1- 0-1997',
      11,
      NULL,
      8.158609,
      58,
      NULL,
      18,
      NULL,
      58,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


