set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7915727';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1341',
      NULL,
      '30142121',
      '44130443',
      '03024302',
      NULL,
      '40222124',
      '30332030',
      '01312212',
      '04430324',
      '00403242',
      '34102412',
      NULL,
      NULL,
      '24042103',
      '21322401',
      '34223101',
      '34142033',
      '32304400',
      '02303414',
      NULL,
      NULL,
      '21042001',
      '02022211',
      '14030030',
      NULL,
      NULL,
      '42442021',
      '40211421',
      '20030003',
      '04320413',
      '21000034',
      '04300120',
      '03312333',
      '23204121',
      '13421102',
      NULL,
      '03313403',
      NULL,
      '20344110',
      '20004402',
      '33241202',
      '43340140',
      NULL,
      '33322432',
      '314',
      '14',
      NULL,
      NULL,
      '3041401',
      NULL,
      1,
      2,
      NULL,
      '140011',
      NULL,
      ' 7-21-1990',
      '11-15-1981',
      47.083816,
      112,
      17.685861,
      4.900661,
      25.129278,
      9.066845,
      2.802567,
      10.140139,
      2.376223,
      1,
      NULL,
      0.086103,
      22.666288,
      NULL,
      3.854359,
      16,
      14.212238,
      NULL,
      2,
      8.034077,
      64.711373,
      18.540953,
      42.718385,
      0,
      1,
      NULL,
      18.256380,
      26.801567,
      38.907288,
      NULL,
      120.587695,
      ' 9-26-1983',
      55,
      33.785209,
      26.124904,
      27,
      22.921615,
      76.866134,
      ' 1-14-1990',
      0,
      1.115822,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.847784,
      NULL,
      0,
      1.225008,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-18-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.048939,
      0.542928,
      NULL,
      1,
      1.701161,
      28.940554,
      0.426586,
      0,
      71,
      NULL,
      NULL,
      NULL,
      ' 7-22-1990',
      31,
      5.857952,
      NULL,
      40.065229,
      88.311786,
      57.327174,
      8.438445,
      NULL,
      23.780701,
      96.985059,
      106.190953,
      76,
      NULL,
      2.822285,
      7,
      8.703022,
      22,
      NULL,
      NULL,
      1.265336,
      NULL,
      NULL,
      6.646694,
      NULL,
      6.824134,
      2,
      20,
      8,
      16.805876,
      1.134045,
      NULL,
      18.277871,
      NULL,
      79.814209,
      3,
      2.248835,
      7.564589,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      29.992076,
      0,
      1,
      ' 5-16-2000',
      1.342912,
      200,
      ' 4-22-1995',
      NULL,
      198.993556,
      4.521579,
      93.841380,
      NULL,
      65.708296,
      NULL,
      139.470939,
      ' 1-24-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


