set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9225698';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '22110423',
      '22330202',
      '23233200',
      '03040044',
      '31343212',
      '41324140',
      '01141330',
      '34031014',
      '01032311',
      '33114330',
      '20000011',
      '34341444',
      '43111044',
      '31014421',
      '44340000',
      '02243223',
      '30322440',
      NULL,
      '13023321',
      '21411434',
      '31234014',
      '13241311',
      NULL,
      '11041124',
      NULL,
      '43432114',
      '24221020',
      NULL,
      '43322444',
      NULL,
      '44141041',
      NULL,
      '20031013',
      NULL,
      '12230322',
      '23034030',
      '11012123',
      '44420041',
      '41033142',
      '20421220',
      NULL,
      '21142314',
      '10222301',
      NULL,
      NULL,
      '24',
      NULL,
      NULL,
      NULL,
      2,
      1.144218,
      NULL,
      NULL,
      '130010',
      1,
      ' 6-20-1979',
      ' 3- 7-1987',
      110.739429,
      NULL,
      8,
      13,
      NULL,
      14,
      106,
      0,
      14,
      NULL,
      27.958037,
      13,
      21,
      15,
      NULL,
      10.664910,
      18,
      NULL,
      62.862954,
      NULL,
      40.519522,
      NULL,
      NULL,
      8,
      0.220622,
      102.728898,
      197.162835,
      39.927774,
      165,
      53.392389,
      NULL,
      '11-24-1984',
      21,
      48,
      NULL,
      NULL,
      124,
      9,
      ' 0- 4-1982',
      2.211918,
      2,
      1,
      0,
      1.065768,
      NULL,
      0.100244,
      0,
      1.950736,
      0.102502,
      0,
      1,
      0,
      0.037574,
      0.254762,
      0.858529,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      102,
      NULL,
      7,
      NULL,
      4,
      8.638954,
      ' 9-27-1984',
      1.589408,
      1.510783,
      159.485148,
      0.022276,
      1.078646,
      114,
      1,
      0.485444,
      53.113551,
      0,
      1.103938,
      NULL,
      '11-21-1976',
      5.719677,
      20,
      2,
      50,
      60.386240,
      NULL,
      38.047740,
      10,
      20,
      46,
      51,
      30,
      ' 4-24-1981',
      10.319297,
      8.248069,
      NULL,
      21,
      1.209881,
      NULL,
      6.265843,
      ' 6-22-1976',
      3.014096,
      23.599006,
      ' 6- 5-1991',
      3,
      NULL,
      4,
      18,
      4,
      6.791885,
      0,
      14.493452,
      0,
      55,
      0.559533,
      9.407734,
      13,
      14,
      0.570685,
      2,
      1.924531,
      0.602823,
      ' 1- 1-2001',
      NULL,
      1,
      3.437637,
      ' 1-15-1982',
      12,
      12.204703,
      ' 9- 4-1984',
      NULL,
      NULL,
      NULL,
      21.801917,
      NULL,
      NULL,
      ' 8- 8-1974',
      NULL,
      21.731249,
      ' 6- 1-1995',
      NULL,
      NULL,
      NULL,
      10,
      12.931641,
      ' 4-12-1996',
      NULL,
      3,
      ' 1-11-1982',
      3,
      2,
      1.325998,
      NULL,
      51,
      15,
      NULL,
      ' 8- 2-1987',
      1,
      56,
      ' 3- 9-1999',
      NULL,
      5.339349,
      18,
      24,
      ' 5-11-1996',
      39,
      0,
      54.934672,
      '10-20-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7);
commit;
end;
/


