set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9225698';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      '03104433',
      '32110201',
      NULL,
      '14114104',
      '22334131',
      '11402230',
      '40423314',
      '21431401',
      '34020432',
      '21232301',
      '43214333',
      '00200311',
      '03131442',
      NULL,
      NULL,
      '32003332',
      '20340421',
      '22331034',
      '00130113',
      NULL,
      '01123142',
      NULL,
      '42112411',
      '43223421',
      NULL,
      '00430424',
      '13202304',
      '22142441',
      '13430034',
      '32113422',
      NULL,
      '31424320',
      '31110043',
      '43103204',
      '21331134',
      '10334402',
      '33130012',
      '10423134',
      '13110304',
      '14202321',
      NULL,
      NULL,
      '31304243',
      '112',
      '21',
      NULL,
      NULL,
      '4231432',
      1.198770,
      27.961624,
      NULL,
      NULL,
      '131322',
      1,
      ' 9-19-1980',
      ' 0-11-1978',
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      4.025670,
      35,
      NULL,
      NULL,
      3.438437,
      NULL,
      12,
      21.886531,
      11,
      NULL,
      2,
      42.277351,
      23.442297,
      NULL,
      14,
      7,
      NULL,
      0.257550,
      81,
      9,
      63.272031,
      5.140699,
      79,
      NULL,
      NULL,
      26,
      NULL,
      28.411151,
      26,
      NULL,
      206.692881,
      NULL,
      0,
      0.929014,
      NULL,
      NULL,
      0,
      0,
      0,
      1.633926,
      NULL,
      0,
      NULL,
      1.222543,
      1,
      0,
      NULL,
      1.422483,
      0,
      0.127087,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-28-1986',
      22,
      0,
      9,
      7,
      3.101841,
      7.248663,
      ' 0-25-1998',
      0.849106,
      2.431020,
      NULL,
      0.036178,
      1.614047,
      102,
      NULL,
      1.633219,
      71.128710,
      NULL,
      NULL,
      NULL,
      ' 7-22-1991',
      NULL,
      59,
      6,
      49.189785,
      76,
      NULL,
      74.001294,
      NULL,
      NULL,
      NULL,
      32.652312,
      NULL,
      ' 8-23-1980',
      NULL,
      16,
      20.095779,
      33,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      28.523912,
      ' 0-14-1983',
      2,
      3,
      NULL,
      23.804505,
      6,
      6,
      NULL,
      9.690058,
      0.414787,
      27.304580,
      NULL,
      NULL,
      10,
      22,
      2,
      3.160745,
      NULL,
      3,
      ' 7-28-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12,
      '11-13-1984',
      NULL,
      NULL,
      NULL,
      26,
      '11- 8-1986',
      41,
      NULL,
      NULL,
      13,
      ' 7- 0-1984',
      NULL,
      71.746148,
      ' 4-22-1977',
      1.710238,
      4,
      ' 4-21-1992',
      NULL,
      NULL,
      NULL,
      2,
      1,
      3.989968,
      NULL,
      61,
      10.572582,
      38.480517,
      ' 1-10-1986',
      1.719968,
      50.699229,
      ' 7- 4-1975',
      NULL,
      8,
      11.389878,
      29,
      ' 4- 2-2003',
      24.648576,
      0.052223,
      47.154559,
      ' 1-13-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


