set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9225698';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '43244332',
      '11111212',
      '41121131',
      '20041131',
      '30442230',
      '22333124',
      '21104123',
      NULL,
      '20134202',
      NULL,
      '24113041',
      '32232021',
      '30212021',
      '03214443',
      '14413301',
      '40211440',
      '41000030',
      '42221411',
      '42221413',
      '44244120',
      '42221033',
      '14213214',
      '02121331',
      '12111422',
      '02034130',
      '03020404',
      '12223323',
      '04244312',
      '04004412',
      NULL,
      '14124411',
      '13242201',
      NULL,
      NULL,
      '33244013',
      '00213021',
      NULL,
      '34233012',
      NULL,
      '42220122',
      '30014221',
      NULL,
      '13444310',
      NULL,
      '242',
      '20',
      19,
      23,
      '1301110',
      0.846029,
      37.943687,
      NULL,
      NULL,
      '143102',
      2.852124,
      ' 1-21-1995',
      '10-15-1978',
      NULL,
      47.858672,
      11.232735,
      0.115942,
      23,
      NULL,
      100.707109,
      20.800657,
      19.795620,
      3.639252,
      42,
      14.509988,
      11.712315,
      1,
      35,
      NULL,
      13,
      5,
      50,
      21.962293,
      65,
      25.825737,
      100.004582,
      18.407882,
      NULL,
      134.457881,
      NULL,
      113,
      NULL,
      175,
      17,
      ' 6-13-1982',
      45,
      31,
      21.130208,
      18,
      173.340810,
      165.965108,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      17,
      5,
      NULL,
      11,
      NULL,
      NULL,
      0,
      1.959938,
      104,
      1,
      1,
      111,
      1,
      0.451192,
      120.493454,
      NULL,
      NULL,
      NULL,
      ' 4- 6-1992',
      82.850434,
      99,
      18.974857,
      11.380382,
      NULL,
      65,
      17,
      84,
      76,
      34.874927,
      37,
      8,
      ' 1-14-1977',
      NULL,
      8,
      29.446972,
      30,
      1.457091,
      85,
      9,
      NULL,
      NULL,
      29,
      ' 5-15-1991',
      8,
      17,
      13.185373,
      NULL,
      21.309611,
      5,
      0,
      NULL,
      0.832083,
      107,
      NULL,
      0.505832,
      1.309223,
      20.754530,
      5,
      3.617613,
      1.432021,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      124.008646,
      17,
      NULL,
      NULL,
      NULL,
      NULL,
      34,
      ' 0-16-1982',
      29,
      ' 5-29-1993',
      3,
      8.198042,
      '11-22-1976',
      54.023221,
      NULL,
      ' 7-28-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.248830,
      ' 0-21-1995',
      56,
      1,
      37,
      NULL,
      0,
      11,
      ' 5- 4-1998',
      NULL,
      NULL,
      22,
      0.704204,
      ' 4-11-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


