set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9225698';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '2',
      '3',
      '0',
      '0',
      '2',
      NULL,
      '0',
      NULL,
      '3',
      NULL,
      '1',
      '2',
      '2',
      NULL,
      '4',
      NULL,
      '4',
      '0',
      '4',
      '0',
      '2',
      '0',
      '2',
      '',
      NULL,
      '',
      NULL,
      '0',
      '4',
      '1',
      '4',
      NULL,
      NULL,
      '4',
      NULL,
      '3',
      NULL,
      '4',
      NULL,
      '1',
      '4',
      '0',
      '4',
      '0',
      '040',
      '01012324',
      30,
      21.320163,
      NULL,
      2.291678,
      1.871635,
      2,
      NULL,
      '330141',
      0.960181,
      ' 2-10-1980',
      ' 7-15-2002',
      89,
      142,
      NULL,
      13,
      18,
      0,
      26.242553,
      25,
      NULL,
      13.157702,
      6.781039,
      6,
      11.729073,
      24,
      NULL,
      12,
      NULL,
      22.160073,
      31.857693,
      30,
      52.095709,
      10,
      11,
      8,
      1,
      NULL,
      NULL,
      78.287154,
      108,
      39.069026,
      93,
      '11-29-1997',
      30,
      9.292596,
      21.926182,
      NULL,
      158.592303,
      38,
      ' 6-22-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      15.951679,
      7.161315,
      4,
      7.134366,
      ' 9-13-1997',
      0.170137,
      1.523185,
      39.493970,
      0,
      NULL,
      82.440544,
      1.323804,
      0.471136,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1- 5-1985',
      39.955398,
      56.212376,
      12.179076,
      37,
      27,
      61,
      109.691702,
      54,
      86.698193,
      69,
      68,
      NULL,
      ' 7-23-2003',
      NULL,
      NULL,
      14.289681,
      NULL,
      NULL,
      42.643590,
      NULL,
      '11-20-1999',
      16,
      33,
      ' 7- 0-2002',
      15.007587,
      NULL,
      4.408049,
      11,
      16,
      4.845489,
      0.240622,
      24,
      NULL,
      80.757688,
      NULL,
      0.396537,
      16.327247,
      6.505950,
      1,
      1.771029,
      0.518929,
      0,
      ' 0- 8-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      45.019171,
      2.878322,
      ' 8-23-1990',
      NULL,
      NULL,
      NULL,
      21,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      31,
      ' 6-27-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      16.636110,
      ' 6-12-1978',
      45,
      23.453885,
      36,
      ' 5- 9-2000',
      0.358505,
      21.178793,
      ' 2- 1-1984',
      4,
      4,
      23,
      25,
      ' 2-17-1998',
      9,
      1.336994,
      77.529975,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


