set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9225698';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      NULL,
      '2',
      '0',
      '0',
      NULL,
      '1',
      '2',
      '0',
      '1',
      '0',
      '2',
      '4',
      '2',
      '0',
      '0',
      '2',
      '2',
      '4',
      '3',
      '3',
      NULL,
      '0',
      NULL,
      '',
      NULL,
      '',
      '4',
      '2',
      '4',
      '3',
      '4',
      '',
      NULL,
      '0',
      '4',
      '4',
      '2',
      '0',
      '4',
      '2',
      '4',
      '0',
      '0',
      '1',
      '121',
      '3',
      63.245608,
      86.867077,
      NULL,
      NULL,
      111,
      0,
      0,
      '433031',
      4,
      ' 9-24-1994',
      NULL,
      NULL,
      318.109389,
      NULL,
      NULL,
      15.689250,
      2.190890,
      101,
      NULL,
      21.418747,
      NULL,
      20.992283,
      NULL,
      15,
      12,
      35.483599,
      NULL,
      0.435710,
      NULL,
      21,
      NULL,
      60.739423,
      1,
      NULL,
      13.184503,
      1,
      NULL,
      202,
      3.581977,
      118,
      244,
      161,
      ' 1-22-1990',
      59,
      0.120302,
      24.974537,
      30,
      59,
      43.579275,
      ' 8- 2-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      37,
      2,
      7,
      8,
      0,
      NULL,
      ' 9-16-1982',
      0.941196,
      1,
      176.761038,
      0.585232,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-12-1979',
      NULL,
      84.878105,
      50,
      40.079546,
      49,
      NULL,
      107.324035,
      55.199030,
      NULL,
      21,
      68,
      64,
      ' 0- 2-1975',
      27.331628,
      1.523037,
      6.873075,
      26,
      23,
      NULL,
      7.014580,
      ' 2-14-1974',
      NULL,
      29,
      '11-18-1995',
      NULL,
      26,
      13.872166,
      12,
      2.645982,
      NULL,
      0,
      1.943099,
      0.256282,
      22.051428,
      1,
      1.577885,
      15.732623,
      NULL,
      1.834812,
      NULL,
      0,
      1.293640,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      137.893338,
      21.641224,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-14-1985',
      8,
      ' 3-28-1977',
      12.177188,
      1,
      NULL,
      24.725728,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      7.213049,
      '10-27-1993',
      43.938993,
      NULL,
      11.010362,
      ' 7-22-1976',
      1.441076,
      NULL,
      ' 9-19-2001',
      15,
      16,
      16.594901,
      18,
      ' 0- 9-1982',
      0,
      1.109838,
      71.217453,
      ' 3- 9-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


