set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8912976';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '40442241',
      '02142340',
      NULL,
      '24424342',
      '34300132',
      '00010430',
      '24330124',
      '31421112',
      '33240222',
      '40323212',
      NULL,
      '44113332',
      NULL,
      '44241313',
      '30214000',
      '23234143',
      '32233102',
      NULL,
      '32124102',
      '31212130',
      '14124134',
      '02040112',
      '32444010',
      '32202431',
      '12131331',
      '33101044',
      '00441012',
      '21312033',
      NULL,
      '41414420',
      '02322211',
      '12303222',
      '01103130',
      '32144023',
      '44111233',
      NULL,
      '40304424',
      '42240003',
      '03401204',
      '43343004',
      '03043320',
      '10400243',
      '31331241',
      '43312021',
      NULL,
      '',
      NULL,
      NULL,
      '2440003',
      3,
      0.934436,
      1,
      NULL,
      '422442',
      NULL,
      ' 5- 7-1998',
      '10-24-1987',
      NULL,
      NULL,
      NULL,
      7,
      12,
      10.542538,
      8,
      11,
      NULL,
      NULL,
      15,
      10,
      NULL,
      NULL,
      9.776522,
      0,
      7.259050,
      3.163660,
      NULL,
      1.035939,
      5.372939,
      5,
      96,
      NULL,
      NULL,
      63,
      63,
      26.855815,
      125.509824,
      111.780202,
      NULL,
      NULL,
      41,
      14.075415,
      6,
      NULL,
      NULL,
      NULL,
      ' 6-28-1996',
      2.819419,
      0.214810,
      7.169163,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-27-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-13-1992',
      17,
      105.417456,
      27,
      102,
      NULL,
      57.157245,
      18,
      NULL,
      98,
      79,
      52,
      11.437817,
      ' 8- 8-1981',
      18.281400,
      5,
      6,
      39,
      29.580088,
      75,
      0,
      ' 1-26-2001',
      15,
      NULL,
      NULL,
      2,
      NULL,
      20,
      7.643236,
      8,
      8,
      NULL,
      22,
      NULL,
      2,
      2.357278,
      4,
      3.089653,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-18-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.184519,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      5.184682,
      22,
      3.334985,
      5.376474,
      ' 1-20-1974',
      1.156173,
      0,
      NULL,
      ' 2-24-1982',
      NULL,
      NULL,
      NULL,
      59,
      47,
      11,
      18,
      67.960526,
      92,
      130.053930,
      86,
      NULL,
      34.869134,
      2,
      22,
      1,
      0.818236,
      6,
      NULL,
      3,
      18,
      5.678871,
      0,
      103,
      3.124980,
      7.794284,
      NULL,
      65.974189,
      NULL,
      33,
      NULL,
      NULL,
      5.042124,
      0,
      NULL,
      0,
      0,
      NULL,
      30.326294,
      42,
      51.943335,
      NULL,
      48.964476,
      39,
      2.242515,
      NULL,
      71.347597,
      1,
      14,
      3.281358,
      17.318199,
      NULL,
      42,
      0,
      5,
      0,
      0,
      45.559227,
      31.700004,
      NULL,
      24.253244,
      23,
      70,
      7,
      NULL,
      8.685193,
      6.660197,
      2.674058,
      4.547707,
      NULL,
      1.736988,
      0,
      1.517470,
      7,
      ' 5-18-1999',
      ' 5-19-2003',
      '11-27-1983',
      ' 5-22-1980',
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


