set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9402430';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0000',
      NULL,
      '32202320',
      '42230304',
      '42323432',
      '14332021',
      '32033430',
      '41212104',
      '14322120',
      NULL,
      '41413332',
      '32222404',
      NULL,
      '13033212',
      '13023343',
      '13432201',
      '23320233',
      '33402301',
      '02102214',
      '00144211',
      '01103413',
      '42343230',
      '02241111',
      NULL,
      '41024023',
      '34321441',
      '00324202',
      '02200232',
      '04004023',
      '13330213',
      '04413213',
      '14301441',
      '03022342',
      '23041102',
      '01134141',
      '34330004',
      '02030243',
      '13342414',
      '24321241',
      '10041212',
      NULL,
      '03232304',
      NULL,
      '01123203',
      '24414400',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.692504,
      1,
      3,
      NULL,
      '321023',
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.793845,
      NULL,
      2.310966,
      2.757287,
      9.205918,
      11.311621,
      5.678184,
      NULL,
      NULL,
      7,
      24,
      10.602441,
      21,
      21.500435,
      22.498748,
      18,
      1.566504,
      14,
      NULL,
      7.176956,
      NULL,
      11,
      1,
      13.918686,
      NULL,
      51.881067,
      53.060634,
      118.762579,
      NULL,
      ' 7- 3-1974',
      NULL,
      11,
      28.849999,
      NULL,
      NULL,
      NULL,
      ' 4-15-1980',
      NULL,
      1,
      4,
      1.441935,
      3,
      2.201440,
      2.281017,
      0.373430,
      1.266200,
      1.781222,
      0,
      0,
      0.609026,
      1,
      1,
      0.108753,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      40,
      7.281701,
      0,
      NULL,
      7,
      4,
      ' 7-22-1992',
      0.148896,
      3,
      NULL,
      0,
      0.683163,
      87,
      0.961212,
      NULL,
      25.658342,
      NULL,
      NULL,
      NULL,
      ' 5-12-1998',
      93,
      55.855205,
      72.430237,
      98,
      43.300009,
      NULL,
      14.940700,
      6,
      73.533318,
      22.420128,
      75,
      NULL,
      ' 5- 6-1997',
      10,
      1,
      15.833090,
      48.372741,
      NULL,
      23.424242,
      5.286574,
      NULL,
      16,
      NULL,
      ' 3- 4-1977',
      3.088821,
      2.818269,
      7,
      NULL,
      11,
      10,
      NULL,
      9,
      3,
      30.242223,
      6.391420,
      0,
      6.592236,
      27.675986,
      0.672713,
      NULL,
      3,
      0,
      '11- 3-1975',
      3,
      1.727510,
      0.929955,
      ' 5-13-1975',
      21,
      3.668117,
      ' 3-25-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-11-1992',
      NULL,
      ' 9-28-1974',
      NULL,
      10,
      ' 6-12-1997',
      36.863377,
      NULL,
      ' 3- 3-1988',
      11.947538,
      4,
      ' 3-17-1982',
      NULL,
      NULL,
      NULL,
      2,
      1,
      12,
      ' 1-20-1998',
      20,
      11.665401,
      21,
      ' 2-25-2000',
      0,
      150.531668,
      '10-18-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.723504);
commit;
end;
/


