set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9217000';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '23112224',
      '11424412',
      '03334302',
      '21141122',
      '32412102',
      NULL,
      '42334421',
      NULL,
      '44114233',
      '04210204',
      '22110133',
      '31104341',
      NULL,
      '02034211',
      NULL,
      '11414022',
      '01032433',
      '40311224',
      NULL,
      NULL,
      NULL,
      '04431044',
      '21230404',
      NULL,
      '32321022',
      NULL,
      '10302444',
      NULL,
      '23410023',
      '23431103',
      NULL,
      '03142121',
      '41130402',
      NULL,
      '33240401',
      '43134301',
      NULL,
      '32334243',
      NULL,
      '02144040',
      '00231410',
      NULL,
      NULL,
      '13434040',
      '423',
      '00',
      NULL,
      NULL,
      '4010314',
      2,
      1.779777,
      0,
      NULL,
      '221202',
      NULL,
      ' 8- 8-1980',
      ' 5-13-1978',
      102.427578,
      NULL,
      55,
      11,
      6,
      7.037688,
      NULL,
      12,
      7,
      4,
      25.288106,
      9,
      25,
      NULL,
      20,
      11.054024,
      NULL,
      7.481598,
      74,
      23,
      NULL,
      6.938264,
      60,
      5,
      0.917250,
      92,
      127.005048,
      NULL,
      123.819806,
      219,
      187,
      '11-20-1982',
      17.687085,
      70.231846,
      21.022890,
      3.635164,
      75.616329,
      20.267117,
      NULL,
      7,
      NULL,
      1,
      0.033327,
      NULL,
      7.130518,
      5,
      1,
      1.214726,
      0,
      0.580129,
      1,
      0,
      0.680879,
      1,
      1,
      3,
      2.073502,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-21-1983',
      9.843505,
      NULL,
      NULL,
      4,
      4,
      3,
      ' 6- 5-1997',
      1,
      1.418367,
      57,
      0,
      0,
      60,
      0,
      1,
      5,
      0.951730,
      2,
      18,
      ' 8-18-1992',
      NULL,
      91,
      73.932164,
      74,
      23,
      27,
      26.023873,
      70,
      6.644978,
      39.842155,
      NULL,
      43.079692,
      ' 3-12-2002',
      7.813073,
      17.095716,
      5,
      17,
      42.313495,
      NULL,
      2.484233,
      ' 3- 8-1995',
      1,
      NULL,
      NULL,
      NULL,
      5.494429,
      15,
      15,
      0.623128,
      13.722442,
      0,
      NULL,
      1,
      52.245747,
      0,
      11,
      3,
      NULL,
      7,
      NULL,
      1.154527,
      1.204458,
      ' 1-29-1974',
      7,
      1.670342,
      1,
      NULL,
      19.516539,
      7,
      ' 4-16-1986',
      NULL,
      NULL,
      NULL,
      11,
      '11-15-1999',
      41.174781,
      ' 3-15-1990',
      11,
      10.280222,
      ' 0-18-1989',
      NULL,
      11.531826,
      ' 1- 8-1974',
      0.201383,
      5,
      '10-28-1992',
      1.633724,
      0,
      NULL,
      2,
      2,
      23.746052,
      ' 9-18-1997',
      54.361403,
      33,
      36.486103,
      ' 0-10-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


