set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8721162';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      NULL,
      '3',
      '4',
      '1',
      NULL,
      '2',
      '2',
      '4',
      '3',
      '1',
      '2',
      '4',
      '1',
      '2',
      '1',
      NULL,
      '4',
      '1',
      '4',
      '4',
      '0',
      NULL,
      NULL,
      '',
      '0',
      '',
      '2',
      NULL,
      NULL,
      '4',
      '0',
      '',
      '',
      '4',
      '4',
      '0',
      NULL,
      NULL,
      '1',
      NULL,
      '1',
      '0',
      '3',
      NULL,
      NULL,
      '24202434',
      21,
      86.126224,
      '0341123',
      NULL,
      NULL,
      0,
      0,
      '321032',
      NULL,
      ' 2-24-1993',
      ' 6-28-1998',
      18,
      215.699369,
      NULL,
      7,
      1,
      7,
      NULL,
      NULL,
      9.494148,
      9.273764,
      NULL,
      NULL,
      26,
      0.688002,
      17.952439,
      2.903476,
      5,
      6,
      NULL,
      10,
      0,
      8.012491,
      NULL,
      3.656109,
      0,
      63,
      81,
      0,
      86.972772,
      43.641007,
      117.549306,
      ' 4-12-1999',
      18,
      3.211988,
      NULL,
      NULL,
      NULL,
      96,
      ' 0- 5-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      36,
      42.616536,
      NULL,
      23,
      19.831478,
      NULL,
      NULL,
      0,
      3,
      135.152287,
      1,
      1.867294,
      105.472519,
      1,
      1.796570,
      92.151448,
      NULL,
      NULL,
      NULL,
      ' 1- 3-1989',
      52,
      96.814993,
      NULL,
      82.916976,
      16,
      51,
      38,
      28,
      NULL,
      63.778092,
      9,
      47,
      '11- 6-1992',
      4.263733,
      18.213595,
      14,
      NULL,
      34,
      8,
      NULL,
      ' 9- 5-1983',
      3.265299,
      NULL,
      ' 7-23-1995',
      3.097592,
      6,
      8,
      0,
      0,
      3.644900,
      0.889973,
      7.027019,
      1,
      63.567777,
      1,
      0.517308,
      1,
      6.032456,
      NULL,
      6.502355,
      0,
      1.635815,
      ' 3- 4-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      123.789710,
      30,
      NULL,
      NULL,
      NULL,
      NULL,
      21,
      NULL,
      NULL,
      '10-12-1996',
      15,
      1,
      ' 6-27-1997',
      86,
      62,
      ' 2-23-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      ' 9-19-1982',
      12.912315,
      NULL,
      4,
      ' 6-17-1988',
      0.958989,
      230.152571,
      ' 7-15-1986',
      7.854646,
      9.492345,
      2,
      7,
      ' 2-27-2003',
      18.675418,
      1.213579,
      64.883904,
      '11-29-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


