set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8929470';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3110',
      '44443113',
      '01134402',
      '13304004',
      NULL,
      NULL,
      NULL,
      '22231210',
      '44331410',
      '22130401',
      NULL,
      '20230030',
      '04404103',
      '43420040',
      '40430200',
      '02121124',
      '31213024',
      NULL,
      '24332042',
      '40341121',
      '31042002',
      NULL,
      '02123200',
      '33314302',
      NULL,
      '34432102',
      NULL,
      '13302412',
      '43141233',
      NULL,
      '22242042',
      '41320223',
      NULL,
      '14002422',
      '13442333',
      '12424333',
      '44130214',
      '03334121',
      '01344122',
      '13222231',
      NULL,
      '12433302',
      '12000330',
      '43043122',
      '43411220',
      '',
      '',
      NULL,
      NULL,
      '2000221',
      3.049685,
      0,
      2,
      NULL,
      '330332',
      0,
      ' 7-15-1998',
      ' 1-24-1978',
      56,
      NULL,
      NULL,
      5.427935,
      1,
      NULL,
      22,
      15,
      21.147928,
      13,
      29,
      NULL,
      37,
      18,
      9.948792,
      21,
      17.843767,
      NULL,
      10,
      14.958620,
      34,
      0,
      114,
      7.311002,
      NULL,
      20,
      12,
      3.364697,
      199.170585,
      NULL,
      40.471984,
      ' 7-26-1978',
      21.554663,
      NULL,
      30,
      NULL,
      61.646758,
      NULL,
      ' 1-23-1985',
      6,
      NULL,
      14.133352,
      2.994929,
      NULL,
      NULL,
      NULL,
      NULL,
      1.813077,
      1,
      NULL,
      1.998707,
      0.525982,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-28-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      85,
      NULL,
      NULL,
      2.823965,
      35.487246,
      34,
      34,
      NULL,
      33,
      94,
      94.291817,
      64.761451,
      NULL,
      20.936105,
      27,
      18,
      NULL,
      53,
      3,
      4.582872,
      ' 0- 7-1987',
      24.903278,
      14.794420,
      ' 7-29-1983',
      NULL,
      18.701681,
      17.492262,
      NULL,
      20,
      8.611716,
      NULL,
      27,
      NULL,
      117.881177,
      0,
      4,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-14-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.411303,
      0,
      33.497674,
      ' 7-26-1992',
      1.468453,
      8.888132,
      ' 9- 2-1988',
      4.714267,
      33.707308,
      23,
      17,
      ' 3-26-1975',
      68,
      1,
      48,
      ' 5-21-1979',
      NULL,
      NULL,
      NULL,
      36,
      55,
      16,
      54,
      18.240349,
      139,
      NULL,
      32.172839,
      NULL,
      NULL,
      2.419041,
      28,
      1.643774,
      2.047807,
      33.639731,
      0.046959,
      0,
      NULL,
      NULL,
      3,
      94.729043,
      1.507907,
      1.979260,
      NULL,
      NULL,
      19,
      43,
      0,
      20,
      0.754831,
      1,
      1.702509,
      0.592653,
      0.689077,
      NULL,
      56,
      71.086463,
      48.227837,
      25,
      43.872848,
      NULL,
      26.042198,
      1.740477,
      55.516227,
      1,
      17,
      1,
      49.500031,
      1.652110,
      NULL,
      0,
      31,
      0,
      0.101731,
      NULL,
      NULL,
      0.426289,
      4,
      NULL,
      32,
      9,
      14.423930,
      NULL,
      0,
      12.606532,
      0,
      1,
      NULL,
      1,
      NULL,
      90.041698,
      ' 2- 5-1987',
      ' 2- 0-1985',
      ' 9-18-1989',
      ' 2-21-1978',
      ' 8- 6-1991',
      ' 1- 7-1987',
      ' 1-12-1981',
      NULL);
commit;
end;
/


