set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7838769';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3011',
      '30020231',
      NULL,
      '13114420',
      '40432322',
      '41114202',
      '13010221',
      '23010233',
      '12122033',
      '31220343',
      '01131333',
      NULL,
      NULL,
      NULL,
      '20140221',
      NULL,
      NULL,
      '34303132',
      '02333320',
      '24443014',
      NULL,
      '02133204',
      NULL,
      NULL,
      '31314440',
      '42231014',
      '23422044',
      NULL,
      '04023010',
      NULL,
      NULL,
      '43024333',
      '34240002',
      '12024043',
      '33010012',
      '31010000',
      '00203440',
      NULL,
      '13243202',
      '40411312',
      '04443430',
      '42141220',
      '33414032',
      '04232414',
      '32010410',
      '',
      '',
      NULL,
      NULL,
      '0323433',
      1,
      NULL,
      NULL,
      NULL,
      '230030',
      0,
      ' 0- 0-1980',
      '10-27-1976',
      7,
      NULL,
      39.089357,
      8.172063,
      14.000857,
      0.920049,
      94,
      0,
      NULL,
      22,
      8.381006,
      0.745355,
      18.090682,
      NULL,
      33,
      10,
      NULL,
      13.177459,
      NULL,
      10,
      48.149798,
      NULL,
      7.265657,
      4,
      NULL,
      69,
      99.983219,
      89.520075,
      167.700001,
      70.372378,
      155,
      NULL,
      52.270565,
      NULL,
      37.896092,
      33,
      136.081906,
      237,
      NULL,
      1,
      7.193831,
      1,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.887640,
      5,
      1.418029,
      0.295034,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-11-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-13-1985',
      60,
      77.580084,
      96,
      50,
      39,
      NULL,
      34,
      89,
      NULL,
      88.433153,
      29,
      109.426217,
      NULL,
      43,
      8.573137,
      7.830684,
      69,
      15.147557,
      18,
      0,
      NULL,
      NULL,
      27.446349,
      '11- 9-1990',
      5.572818,
      12.275685,
      10,
      25,
      6,
      3,
      NULL,
      24.815036,
      NULL,
      NULL,
      5.112475,
      1,
      6.428816,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2- 6-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      23.606258,
      12,
      ' 9-24-2002',
      1.485030,
      47.510502,
      NULL,
      4,
      11,
      17,
      22,
      ' 2-22-1986',
      35,
      0.203902,
      186.152668,
      ' 0-12-1994',
      NULL,
      NULL,
      NULL,
      84,
      48.613422,
      37,
      8,
      129,
      99,
      68,
      23.703572,
      NULL,
      5.048303,
      4,
      23.412619,
      NULL,
      NULL,
      109.135566,
      1,
      NULL,
      NULL,
      2,
      1.107056,
      109,
      1,
      1,
      14.906874,
      NULL,
      22.013492,
      NULL,
      0,
      46.939070,
      1.839239,
      1,
      0,
      6.402833,
      1.134237,
      1,
      2,
      181,
      NULL,
      4,
      85.775867,
      127.627564,
      1,
      0.570543,
      4,
      NULL,
      16.116475,
      0,
      6,
      1.839340,
      114.275571,
      3.813384,
      35.819797,
      0.198850,
      0,
      100.021240,
      NULL,
      2,
      18,
      45,
      113.459986,
      27.329389,
      161,
      10.451536,
      0.059544,
      0.069528,
      1,
      1.080489,
      NULL,
      NULL,
      0,
      144,
      ' 7-23-1978',
      '10-13-1986',
      NULL,
      '11-29-1979',
      ' 6-13-1991',
      '10-12-1995',
      ' 4-21-1977',
      NULL);
commit;
end;
/


