set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8702425';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3021',
      '23032020',
      '44200424',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '31441100',
      NULL,
      NULL,
      '13234041',
      '32114003',
      '11331404',
      '00122104',
      '01224040',
      '22320104',
      '12411140',
      '43222410',
      '12211231',
      '42134400',
      '00030143',
      '31230413',
      '24432133',
      '23414020',
      '34242400',
      '30022223',
      '13403421',
      NULL,
      '01040212',
      '32402430',
      NULL,
      '31044000',
      '21120131',
      '31131412',
      NULL,
      '10431402',
      '01122202',
      '40140131',
      '20120132',
      '30141320',
      '24413431',
      NULL,
      NULL,
      '03143434',
      NULL,
      NULL,
      NULL,
      NULL,
      '0304301',
      1.806988,
      1,
      1,
      NULL,
      NULL,
      2.107607,
      ' 2- 0-1976',
      '10-27-1981',
      27,
      NULL,
      NULL,
      26.696196,
      27,
      8,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      14.121343,
      13.842289,
      32.266041,
      23.464364,
      11,
      NULL,
      18,
      95.401121,
      16.081699,
      4.515566,
      1,
      150,
      29.542357,
      NULL,
      94.982103,
      NULL,
      84,
      227.480282,
      166.647047,
      250.684906,
      ' 0- 4-1975',
      63.688373,
      39,
      36,
      35.025519,
      163,
      194.743789,
      ' 7- 9-1993',
      1.116010,
      1,
      0,
      3.467908,
      NULL,
      NULL,
      NULL,
      NULL,
      0.289076,
      0.650594,
      1,
      0.192225,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      32.238629,
      87,
      NULL,
      49.756533,
      57.494281,
      81.577972,
      1,
      61,
      9.174592,
      76.272494,
      5.686133,
      NULL,
      '10-25-2001',
      30,
      12.945279,
      42.261117,
      126.805021,
      70.013423,
      NULL,
      4.713852,
      ' 6-11-1990',
      2,
      40.256600,
      ' 0- 2-1989',
      12,
      25.928239,
      NULL,
      3.132557,
      9.162515,
      12.031328,
      NULL,
      20.883298,
      NULL,
      96.406982,
      1.408940,
      0.310185,
      3.147110,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1- 8-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.062130,
      NULL,
      26,
      ' 1-13-1981',
      0,
      NULL,
      ' 4-22-1977',
      12,
      NULL,
      7,
      35.400461,
      ' 1-11-1999',
      NULL,
      0,
      13.822797,
      ' 2- 9-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      125.247353,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.724214,
      0.075553,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      100,
      NULL,
      1.179810,
      123,
      NULL,
      8.341387,
      NULL,
      1,
      NULL,
      2.289248,
      NULL,
      1.575281,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.166261,
      NULL,
      0,
      1,
      NULL,
      27.370689,
      NULL,
      17,
      NULL,
      NULL,
      20,
      NULL,
      19,
      1,
      0,
      1,
      0,
      1,
      0,
      3,
      NULL,
      NULL,
      ' 9-25-1992',
      '10-11-1975',
      NULL,
      '11- 3-1996',
      ' 2-22-2001',
      NULL,
      NULL);
commit;
end;
/


