set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9512010';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3134',
      '43412314',
      '13200141',
      '31210422',
      '11214412',
      '10303311',
      '10430134',
      NULL,
      '11111212',
      '33001032',
      '22344111',
      NULL,
      NULL,
      '23413231',
      '32113001',
      '40433433',
      '41132104',
      '10331112',
      '10000411',
      '34433302',
      NULL,
      '12031334',
      '11114301',
      '00203014',
      '42241440',
      NULL,
      '44333141',
      '24144203',
      NULL,
      NULL,
      '42322302',
      '12323114',
      NULL,
      '31010021',
      '11233141',
      '20320411',
      '10412133',
      '43124012',
      NULL,
      '04141203',
      '14200314',
      NULL,
      '04024033',
      NULL,
      NULL,
      '020',
      NULL,
      33,
      5,
      '1020400',
      0.150383,
      1,
      NULL,
      NULL,
      '322140',
      1,
      ' 5- 3-1983',
      NULL,
      25.953300,
      NULL,
      27.084399,
      5,
      28.454044,
      23,
      83,
      11.775840,
      5,
      9,
      4.023130,
      NULL,
      15.345478,
      NULL,
      11,
      16.775999,
      4,
      13.839153,
      30.349741,
      7.561022,
      12,
      16.410311,
      NULL,
      7,
      0.489890,
      11.588819,
      84.192304,
      42.791602,
      63.969008,
      NULL,
      68,
      NULL,
      NULL,
      46.629887,
      17.119560,
      23,
      NULL,
      195.957484,
      ' 1-25-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      46,
      31,
      11.167166,
      15,
      10.830904,
      NULL,
      ' 7- 9-1988',
      1.684618,
      0,
      168,
      1,
      1,
      17,
      1,
      0,
      58,
      NULL,
      NULL,
      NULL,
      ' 3- 5-1991',
      30,
      62.367240,
      59,
      91,
      35,
      67,
      17.096076,
      31.186475,
      56.904324,
      NULL,
      52,
      50.761595,
      ' 6-28-1983',
      19,
      8.400579,
      11,
      79,
      72,
      NULL,
      6.975843,
      NULL,
      NULL,
      15,
      NULL,
      3,
      20,
      10,
      NULL,
      8.551086,
      0,
      1.189047,
      NULL,
      0.494236,
      67.198093,
      2.999721,
      3,
      3,
      12,
      NULL,
      3,
      1.998948,
      0,
      ' 3-12-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      173.356259,
      16.723693,
      ' 8-16-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-14-1996',
      3,
      '11-10-2003',
      NULL,
      NULL,
      ' 6- 0-1992',
      30.971972,
      NULL,
      '11-13-1981',
      3.668466,
      NULL,
      ' 4- 6-2001',
      NULL,
      NULL,
      NULL,
      2,
      3,
      6,
      ' 4-20-1995',
      35,
      14,
      25,
      ' 5-20-1979',
      1,
      5,
      ' 5-16-1996',
      12.009260,
      2,
      NULL,
      NULL,
      NULL,
      18,
      0.187732,
      59,
      ' 0- 8-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


