set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9512010';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2311',
      '34420203',
      '10333040',
      '30030021',
      '33003234',
      '32021310',
      '31021211',
      '30141241',
      '14011231',
      '34434201',
      NULL,
      '20401110',
      NULL,
      NULL,
      '10210113',
      NULL,
      '40203130',
      '33041343',
      '41331421',
      NULL,
      '04100342',
      NULL,
      NULL,
      '04014024',
      '02420410',
      '20024341',
      '02301001',
      '02423124',
      '33401133',
      '43010104',
      '03213130',
      '14324213',
      '02434043',
      '04403020',
      '12340203',
      '21421242',
      '30214123',
      '22323022',
      NULL,
      '34442211',
      '41341204',
      '10112312',
      '24003104',
      '01101241',
      '04441433',
      '142',
      '00',
      NULL,
      25,
      '2321134',
      2,
      44.086972,
      0,
      NULL,
      '021021',
      NULL,
      ' 7- 0-1998',
      ' 4-10-1976',
      92,
      25,
      NULL,
      14,
      27,
      0.771849,
      55,
      2.793879,
      18,
      4.258348,
      21,
      11.219849,
      NULL,
      18,
      1,
      12.509892,
      28,
      12,
      11,
      13,
      32.122507,
      NULL,
      24,
      14,
      NULL,
      NULL,
      166.431173,
      105,
      111,
      199.839087,
      37,
      NULL,
      17.425105,
      31.290361,
      0.829381,
      NULL,
      57,
      NULL,
      ' 6-25-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      89.153126,
      14,
      11,
      NULL,
      2,
      8,
      NULL,
      0,
      0,
      202,
      0.168195,
      0.602062,
      79,
      1.043709,
      3.029333,
      36.674251,
      NULL,
      NULL,
      NULL,
      ' 1- 9-1977',
      70,
      16,
      90,
      88.085639,
      50,
      70.029620,
      24.366858,
      34.389923,
      1,
      7.549722,
      75,
      76.014871,
      ' 6-17-1989',
      30.367839,
      14.833659,
      5.785148,
      95,
      72,
      171,
      6,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      9,
      6,
      0.306384,
      19,
      9,
      NULL,
      11.632265,
      NULL,
      NULL,
      3,
      0.743629,
      NULL,
      19.662023,
      4.308086,
      1,
      0,
      0,
      ' 4- 7-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      138,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      NULL,
      39,
      ' 5-10-2002',
      15,
      1,
      ' 1-10-1975',
      153.337174,
      NULL,
      ' 0-23-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      9,
      ' 0- 4-1990',
      34,
      NULL,
      NULL,
      ' 3-17-1985',
      0,
      70,
      ' 9- 7-1974',
      1.631242,
      8.296400,
      14,
      35,
      ' 8-29-1981',
      NULL,
      1,
      106,
      '10- 7-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


