set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9512010';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      NULL,
      '3',
      '3',
      '4',
      NULL,
      '0',
      NULL,
      '0',
      '2',
      '0',
      '1',
      '3',
      '2',
      '1',
      '0',
      '3',
      '4',
      '1',
      '2',
      '1',
      '0',
      '4',
      '4',
      '',
      NULL,
      '',
      '2',
      '4',
      '3',
      NULL,
      NULL,
      '',
      '',
      '1',
      '2',
      '0',
      '0',
      '3',
      '0',
      '4',
      '3',
      NULL,
      NULL,
      '4',
      '343',
      NULL,
      7.994434,
      23,
      '1124101',
      2.477035,
      214,
      3,
      0,
      NULL,
      4,
      ' 1-19-2003',
      '10-26-1980',
      63.086236,
      133,
      18.914552,
      4.765509,
      3,
      20.308942,
      71.072615,
      21.576049,
      14.706618,
      NULL,
      33.693636,
      5,
      3,
      NULL,
      13.754287,
      1.214366,
      18,
      15.818868,
      NULL,
      10,
      NULL,
      22,
      76,
      14,
      1,
      90,
      NULL,
      60,
      46,
      NULL,
      80.379238,
      ' 0- 4-1998',
      39.272567,
      NULL,
      NULL,
      19.374254,
      83.841104,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      41,
      0,
      9,
      1.937302,
      6,
      3,
      ' 9-28-1991',
      0.838435,
      1,
      NULL,
      1.080936,
      3.451372,
      80.016449,
      NULL,
      1,
      39,
      NULL,
      NULL,
      NULL,
      ' 2-11-1976',
      71,
      45.065315,
      55.595434,
      54.148951,
      31,
      27.197602,
      NULL,
      NULL,
      NULL,
      0.065640,
      40,
      7.887155,
      '10-13-1981',
      3.785558,
      3.369817,
      8,
      37,
      64,
      0.993807,
      8,
      ' 5-23-1997',
      11,
      4.834925,
      ' 4- 9-1981',
      9,
      9,
      NULL,
      13,
      5.670854,
      NULL,
      0.504193,
      4,
      NULL,
      67.993999,
      0,
      NULL,
      3.840793,
      13.070400,
      NULL,
      1,
      NULL,
      1,
      ' 5-22-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      20,
      ' 0-14-1987',
      53.394189,
      '11-21-2000',
      0,
      10,
      ' 3-25-1986',
      81.752956,
      33.263548,
      '11-23-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      21,
      NULL,
      15.681573,
      1.433965,
      6,
      ' 5-24-2000',
      NULL,
      92.615929,
      ' 0-12-1976',
      5,
      23.257206,
      NULL,
      NULL,
      ' 1-16-1976',
      19.042776,
      1,
      50,
      ' 8-15-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


