set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7226915';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '31044444',
      NULL,
      NULL,
      '34000401',
      '21321411',
      '11203000',
      '24044013',
      '20242214',
      '03044121',
      NULL,
      NULL,
      '42303023',
      '22411202',
      '34022031',
      '12141012',
      '24344304',
      '31210204',
      '03014424',
      '00411041',
      '00234032',
      '13032113',
      '40403414',
      '02034223',
      '30242222',
      '20142041',
      '42202201',
      NULL,
      '02144404',
      '23304240',
      '13123142',
      '34110313',
      '12400110',
      NULL,
      '13321023',
      '20421444',
      '41423023',
      '22104044',
      '22331312',
      '13122233',
      '01240440',
      '20404141',
      '33144444',
      '23321433',
      '11422440',
      '',
      '',
      NULL,
      NULL,
      '2443100',
      2,
      1,
      0,
      NULL,
      '021134',
      0.762592,
      ' 8-17-2001',
      ' 9-20-1996',
      NULL,
      NULL,
      25,
      12.099495,
      5,
      NULL,
      56.983518,
      NULL,
      22,
      9,
      32.548793,
      27,
      11.543375,
      6,
      NULL,
      14,
      29,
      21.010489,
      91.893354,
      NULL,
      NULL,
      4.989563,
      49.204645,
      18.066879,
      NULL,
      33.263730,
      249.000166,
      86,
      214.257743,
      249,
      182.487192,
      ' 9-21-1984',
      47.724677,
      NULL,
      10.585587,
      2.744228,
      NULL,
      NULL,
      NULL,
      2.471889,
      0.490384,
      NULL,
      0.666777,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.802580,
      4,
      NULL,
      1,
      0.086981,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-22-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      144.820902,
      9,
      6.760091,
      101,
      118,
      NULL,
      NULL,
      112.814064,
      86,
      33.188440,
      NULL,
      125,
      ' 9-12-1993',
      32.925705,
      0,
      16.380658,
      87,
      80.032850,
      37,
      15,
      ' 2- 7-1974',
      NULL,
      19,
      NULL,
      8,
      6,
      19,
      7,
      10,
      2,
      NULL,
      15,
      NULL,
      138.012111,
      NULL,
      4.808652,
      10.198806,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4- 2-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      58.263498,
      33,
      '11-21-1979',
      1,
      11,
      ' 2- 4-1981',
      2.060537,
      14.722347,
      NULL,
      29,
      ' 9- 7-1974',
      52,
      1,
      83,
      '11-22-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      79,
      0,
      NULL,
      NULL,
      NULL,
      0,
      5,
      3.469911,
      NULL,
      4.013314,
      NULL,
      0.013551,
      1,
      63,
      0.083429,
      1.642229,
      NULL,
      1.976669,
      0.624703,
      41.842753,
      NULL,
      NULL,
      107.500827,
      NULL,
      30,
      NULL,
      1.216036,
      NULL,
      1.838481,
      0.479071,
      NULL,
      1,
      0,
      0.900934,
      NULL,
      NULL,
      NULL,
      12.920973,
      NULL,
      NULL,
      0,
      16.993839,
      30.373801,
      1,
      NULL,
      NULL,
      17.747466,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.248862,
      NULL,
      27.192556,
      25,
      33.560318,
      NULL,
      NULL,
      6.812032,
      NULL,
      6.473104,
      0,
      1,
      0,
      1.361976,
      1.002986,
      0.235535,
      NULL,
      NULL,
      ' 2-12-1977',
      ' 4- 3-1996',
      ' 4- 4-1980',
      ' 1- 7-1975',
      ' 9-16-1999',
      ' 7-28-1987',
      ' 1- 9-1979',
      NULL);
commit;
end;
/


