set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9228941';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3424',
      '41430321',
      '14311301',
      '41040440',
      '42142330',
      '34433100',
      '14133233',
      '24413304',
      '12430402',
      '24133012',
      '24331323',
      '03340344',
      '03144343',
      '42324303',
      '40004341',
      '01332244',
      NULL,
      '11444112',
      '20111242',
      '12431110',
      '43312000',
      '04242013',
      '44241422',
      '04303031',
      '00443042',
      '12020021',
      '21101441',
      NULL,
      '31302030',
      '14220244',
      '02410421',
      '12423142',
      '42234201',
      NULL,
      '31324120',
      '01012113',
      '01122420',
      '01433441',
      '24003230',
      '00432404',
      '10100333',
      '20411334',
      '41100141',
      '01323120',
      '13243412',
      '212',
      '00',
      NULL,
      NULL,
      '2442323',
      3.919702,
      1,
      1,
      NULL,
      '134042',
      NULL,
      ' 7- 4-1977',
      '11- 8-1976',
      44.253125,
      NULL,
      13.600417,
      10,
      13.263918,
      5,
      11.966728,
      13,
      0.938539,
      3.309720,
      18,
      2.641577,
      20,
      16,
      NULL,
      NULL,
      NULL,
      2.340138,
      10.184500,
      16.416309,
      8,
      1.969297,
      45.556943,
      3.773241,
      NULL,
      20,
      NULL,
      85.343187,
      40.999107,
      8.546968,
      100,
      ' 5- 3-1980',
      32,
      NULL,
      17.242910,
      20,
      47,
      NULL,
      ' 2- 4-1989',
      4.804139,
      0,
      NULL,
      3,
      NULL,
      1.557711,
      1.030589,
      0,
      1.859026,
      0,
      1,
      1,
      0,
      5,
      1.321842,
      0,
      NULL,
      1.947195,
      NULL,
      1.220966,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-22-1977',
      NULL,
      NULL,
      NULL,
      1.427419,
      6,
      3,
      '11-18-1976',
      1,
      NULL,
      139,
      0,
      0.023533,
      134,
      0,
      0.721195,
      52.419056,
      NULL,
      0.234243,
      1,
      ' 5- 7-1991',
      81.432618,
      67.045625,
      49.229418,
      47.710645,
      NULL,
      102.544522,
      26,
      45.473987,
      13,
      89.868708,
      3,
      NULL,
      ' 4-14-1977',
      NULL,
      NULL,
      NULL,
      22.586652,
      37.554675,
      40,
      3,
      ' 1- 1-2002',
      NULL,
      NULL,
      ' 4-15-1993',
      NULL,
      10.754851,
      NULL,
      8.378388,
      NULL,
      0.331556,
      1.788115,
      10,
      1,
      51,
      0,
      NULL,
      1.295827,
      7,
      0,
      2,
      2,
      1.649149,
      '10-13-1976',
      0,
      3.481620,
      2.219055,
      ' 3- 7-1999',
      136.546015,
      5,
      '10-12-1975',
      NULL,
      NULL,
      NULL,
      52.993556,
      ' 9-12-1990',
      5,
      NULL,
      1.763985,
      19,
      ' 9- 8-1979',
      150.895097,
      37.121550,
      ' 0- 5-1976',
      0,
      4.237134,
      ' 0-26-1979',
      NULL,
      7,
      ' 7- 5-1980',
      NULL,
      2,
      4.817108,
      NULL,
      55,
      57,
      26.065533,
      '11- 9-2001',
      1.083549,
      60,
      ' 8-21-1975',
      NULL,
      4,
      22.837986,
      5,
      ' 2-13-1987',
      68.082803,
      1,
      78,
      ' 0- 4-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.187951);
commit;
end;
/


