set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9228941';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1320',
      '22103044',
      '10441223',
      '13131213',
      '23221120',
      NULL,
      '33422042',
      '41133100',
      '43423221',
      '44111201',
      '20021042',
      NULL,
      '33033232',
      '00030240',
      NULL,
      '34231011',
      '03134344',
      '30041400',
      '23111322',
      '40440244',
      NULL,
      '01424030',
      '33133433',
      '01110412',
      '21314333',
      '14104344',
      '10212044',
      '14012022',
      '40230211',
      '41311233',
      '10112001',
      '31240134',
      '41200223',
      '44040332',
      '23241403',
      '41342141',
      '01302214',
      '31024220',
      '44343020',
      '04002034',
      '21444111',
      '31241133',
      '11032220',
      '12404322',
      NULL,
      '120',
      NULL,
      NULL,
      NULL,
      NULL,
      2.993059,
      9.969784,
      NULL,
      NULL,
      NULL,
      3.756135,
      '10-20-1985',
      '10- 9-1975',
      NULL,
      NULL,
      0,
      4,
      NULL,
      17,
      NULL,
      4,
      14,
      19,
      8.784324,
      NULL,
      24.232031,
      12.229679,
      NULL,
      18.354783,
      28.488314,
      NULL,
      52.918991,
      2,
      27,
      16,
      0.477924,
      NULL,
      0,
      NULL,
      12.550954,
      40,
      48.378684,
      185,
      80.817693,
      ' 0-25-1974',
      NULL,
      30,
      12,
      0.539251,
      94,
      226,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.233961,
      6.254576,
      2.021018,
      9.389201,
      2.540874,
      ' 8-26-1985',
      NULL,
      1,
      NULL,
      0,
      NULL,
      143.071672,
      2,
      1,
      19.026987,
      NULL,
      NULL,
      NULL,
      ' 0-25-2001',
      32,
      22.522938,
      32,
      19.695686,
      53,
      75.253770,
      19,
      26.684627,
      40,
      62,
      96.885281,
      17,
      ' 2-28-1991',
      21,
      10,
      11.681929,
      19.413288,
      40,
      9.191335,
      2.986948,
      NULL,
      15.695391,
      NULL,
      NULL,
      NULL,
      4.014255,
      NULL,
      19,
      9,
      3.756540,
      0.997571,
      7.559638,
      1.594216,
      83,
      2.544446,
      7.679850,
      14,
      17.689472,
      4,
      NULL,
      1.586758,
      1.314981,
      ' 4- 0-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      158.907493,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      12,
      ' 9-28-1977',
      26,
      ' 9- 0-1999',
      NULL,
      12,
      ' 6-28-1996',
      129.433246,
      NULL,
      NULL,
      17.023879,
      0,
      ' 2- 8-2003',
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      12,
      NULL,
      NULL,
      58,
      26.320162,
      ' 4-27-1977',
      1,
      151,
      ' 4-18-1975',
      NULL,
      9,
      NULL,
      2.691474,
      '11- 5-1990',
      17.755540,
      0,
      103.722259,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


