set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9228941';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1123',
      NULL,
      '40141131',
      '43422133',
      '21224140',
      '01003033',
      '12134441',
      '01023200',
      NULL,
      '34120244',
      NULL,
      '24432332',
      '24234421',
      '44331111',
      '33214233',
      '12024442',
      '44000423',
      NULL,
      '41033144',
      '02233213',
      NULL,
      '11123121',
      '04043013',
      '40004001',
      '42001314',
      '03143020',
      '10224321',
      '13412200',
      '23323334',
      '43333031',
      '42043342',
      '42122120',
      NULL,
      '43422224',
      '03033123',
      '22243314',
      '12230330',
      '32410404',
      '14104322',
      NULL,
      '43004041',
      '30014044',
      NULL,
      '43332321',
      NULL,
      NULL,
      '13',
      NULL,
      17,
      '2112114',
      NULL,
      5.125873,
      NULL,
      NULL,
      '003133',
      0.379248,
      NULL,
      ' 4-16-2001',
      NULL,
      NULL,
      8.114106,
      3.041301,
      30.375725,
      0,
      14.296032,
      10.265382,
      18.185806,
      16.095588,
      16.861408,
      NULL,
      9.875615,
      11,
      5.044940,
      10,
      15,
      9,
      25,
      NULL,
      38,
      19,
      71.278548,
      7,
      0,
      90,
      NULL,
      NULL,
      NULL,
      165,
      NULL,
      ' 8-10-1986',
      34.631979,
      16.656928,
      23,
      19.610214,
      127.302208,
      113.439022,
      ' 5-24-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.744668,
      3,
      6.088844,
      12,
      2.122122,
      '11-15-1992',
      NULL,
      1.576104,
      139,
      NULL,
      NULL,
      71.124334,
      NULL,
      1.367055,
      16,
      NULL,
      NULL,
      NULL,
      ' 5-10-1988',
      NULL,
      91.335717,
      51.608055,
      42.176503,
      44.552239,
      69,
      NULL,
      54.229861,
      34.174222,
      NULL,
      43,
      46.707065,
      ' 4- 1-1987',
      6,
      0,
      2.457160,
      5.435095,
      48,
      22.173484,
      NULL,
      ' 3-27-1981',
      NULL,
      2,
      NULL,
      8,
      NULL,
      6.869374,
      15.044610,
      0,
      5,
      1.145832,
      1.027454,
      1,
      27.431782,
      4,
      0,
      6,
      NULL,
      9,
      1.613272,
      0,
      0.877566,
      ' 5- 6-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      120,
      1.342613,
      NULL,
      NULL,
      NULL,
      NULL,
      57.780630,
      ' 5- 9-2003',
      36.610355,
      ' 1-21-1976',
      13,
      13,
      ' 9-24-1978',
      132,
      91,
      ' 9- 2-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      NULL,
      11.957231,
      43.222781,
      29,
      NULL,
      1.682999,
      NULL,
      ' 0-29-1979',
      NULL,
      71,
      9,
      12,
      ' 3-24-1981',
      NULL,
      NULL,
      90.447360,
      '11-13-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


