set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9228941';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      NULL,
      '3',
      '3',
      '3',
      '0',
      '2',
      '4',
      '3',
      '3',
      '0',
      '0',
      '2',
      NULL,
      NULL,
      NULL,
      '2',
      '3',
      '4',
      NULL,
      NULL,
      NULL,
      '0',
      '0',
      '',
      '3',
      '',
      '0',
      '1',
      '0',
      NULL,
      '0',
      '',
      '',
      '2',
      '0',
      '3',
      '0',
      '0',
      '1',
      '3',
      '3',
      NULL,
      NULL,
      '2',
      '410',
      '32010033',
      NULL,
      15.425253,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      '010402',
      NULL,
      ' 2-19-1981',
      ' 1- 8-1976',
      60.567404,
      132,
      5.917249,
      7.271074,
      21,
      NULL,
      12.710791,
      0.094583,
      24,
      NULL,
      NULL,
      NULL,
      35,
      6,
      21.080852,
      NULL,
      5,
      25.537705,
      77,
      39.880132,
      NULL,
      10.438930,
      30.196287,
      NULL,
      NULL,
      90.711834,
      156,
      115,
      3,
      70.210827,
      197.712697,
      ' 0-10-2001',
      32.224174,
      55,
      9,
      NULL,
      29.985480,
      7.403693,
      ' 2- 8-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      6.064373,
      NULL,
      3,
      6.573974,
      7,
      NULL,
      0,
      NULL,
      78.057017,
      NULL,
      1,
      24,
      0.950742,
      1,
      60,
      NULL,
      NULL,
      NULL,
      ' 3-27-1993',
      39,
      NULL,
      NULL,
      28,
      NULL,
      65,
      70.365576,
      94.286519,
      48.440571,
      79.808809,
      66,
      28.872308,
      ' 8-21-1996',
      10.921640,
      NULL,
      2.490141,
      30.120121,
      NULL,
      0,
      4,
      ' 8- 2-1976',
      7,
      NULL,
      NULL,
      7.716398,
      6,
      3.426492,
      15,
      11,
      NULL,
      0,
      4,
      1.550415,
      NULL,
      0,
      0.693515,
      NULL,
      3,
      11,
      5,
      1,
      NULL,
      ' 2-20-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      186.078547,
      0,
      ' 0-22-1978',
      NULL,
      NULL,
      NULL,
      48,
      NULL,
      13.847104,
      ' 4-13-1981',
      2.352248,
      9.620781,
      ' 8- 3-1980',
      146,
      49.528363,
      ' 4-24-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      13,
      ' 5- 7-1998',
      27,
      39.462020,
      11.692904,
      ' 8- 8-2003',
      2.739037,
      131,
      ' 1-28-2001',
      4.833031,
      13,
      10,
      40.670556,
      ' 1- 6-2001',
      44,
      0,
      NULL,
      ' 9-18-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


