set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9112150';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2133',
      '31242010',
      '03342144',
      '21314033',
      '20330223',
      '32010333',
      '44444100',
      '32403203',
      '21111004',
      '44023324',
      '12030310',
      '31243304',
      '23310300',
      NULL,
      '32223214',
      '13340204',
      NULL,
      '11223423',
      '03221341',
      '42013223',
      NULL,
      NULL,
      '40333001',
      NULL,
      '14022434',
      '12210130',
      NULL,
      NULL,
      '34104021',
      '10044012',
      '34314342',
      '01114411',
      '42322314',
      '20203120',
      '11023434',
      NULL,
      '20141342',
      NULL,
      '01302443',
      '11224344',
      '03024243',
      '40141040',
      NULL,
      '11143331',
      '34102144',
      '',
      '',
      NULL,
      NULL,
      '0024243',
      NULL,
      0,
      0,
      NULL,
      '234232',
      1.450352,
      ' 5-13-2002',
      NULL,
      66.523924,
      NULL,
      18.973882,
      19,
      9.002708,
      NULL,
      37.025388,
      25.606722,
      NULL,
      16.594475,
      52.459967,
      10.685456,
      30,
      12,
      26,
      NULL,
      NULL,
      17,
      2.814506,
      13,
      36,
      1.463880,
      NULL,
      1,
      NULL,
      137.111028,
      177.568881,
      3.896723,
      163.429288,
      85,
      NULL,
      ' 9- 2-1980',
      40,
      NULL,
      7.306471,
      33,
      111,
      76.599428,
      ' 2-20-1994',
      NULL,
      2.741421,
      1,
      1.019560,
      NULL,
      NULL,
      NULL,
      NULL,
      0.900978,
      1,
      NULL,
      1,
      0.865648,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-20-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-25-1992',
      116,
      101.677186,
      81,
      97,
      82,
      NULL,
      27,
      32,
      35,
      12.101036,
      95,
      20.014430,
      NULL,
      NULL,
      NULL,
      8.388167,
      86,
      139.196839,
      66.794995,
      8.779320,
      ' 4- 8-1997',
      33.277999,
      NULL,
      ' 2-14-1987',
      16,
      NULL,
      NULL,
      2,
      8,
      5,
      NULL,
      15.609894,
      NULL,
      8,
      NULL,
      5.346333,
      16,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 3-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15,
      NULL,
      7,
      ' 4-27-1974',
      1.751585,
      108.982594,
      ' 0-17-1975',
      10.384878,
      NULL,
      22,
      NULL,
      '10-22-1998',
      54.815290,
      0,
      27.870045,
      ' 5-19-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.544049,
      72.252465,
      110.872909,
      105.722236,
      9.064162,
      11,
      NULL,
      3,
      NULL,
      75.350133,
      NULL,
      0.873140,
      19,
      NULL,
      NULL,
      NULL,
      1.088607,
      1,
      88,
      1.549345,
      0.326072,
      142,
      6,
      8,
      108.726619,
      0,
      93,
      NULL,
      0,
      0,
      1.996276,
      1,
      0,
      11.180525,
      120.314305,
      26.741536,
      NULL,
      42.675568,
      49,
      1.316618,
      NULL,
      19.530051,
      1.061782,
      0.420599,
      10,
      26,
      1,
      7.181040,
      1.823964,
      43,
      0.150304,
      0,
      81.568850,
      15,
      25,
      12,
      119.752765,
      27.794758,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      2.360797,
      0.056041,
      0,
      58.938010,
      ' 4-14-2000',
      ' 3-20-1982',
      ' 4-22-1982',
      ' 4-10-1990',
      '10-24-1975',
      ' 0-15-1984',
      ' 6-15-1979',
      NULL);
commit;
end;
/


