set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9112150';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0321',
      '12040221',
      '10412443',
      NULL,
      NULL,
      '24333034',
      '24432214',
      '22321023',
      '30114032',
      '40003232',
      '40401112',
      '41310434',
      '22424123',
      '11100230',
      NULL,
      '24024321',
      '10211202',
      NULL,
      '32331440',
      '43314220',
      '30324231',
      '20412201',
      '40341000',
      NULL,
      NULL,
      NULL,
      '40244404',
      '21133303',
      '40311010',
      '22204434',
      '23012340',
      '31423032',
      NULL,
      '30034420',
      '20413114',
      '20413212',
      '42200343',
      '13044332',
      '41334324',
      '01310340',
      '44010224',
      '33403200',
      NULL,
      '34104314',
      NULL,
      '221',
      '42',
      14.107252,
      NULL,
      NULL,
      3,
      18.587331,
      3,
      NULL,
      '033100',
      4,
      ' 8-25-1997',
      '10-22-1982',
      19.797523,
      NULL,
      39.494572,
      13,
      14,
      5,
      124.860309,
      27,
      6,
      NULL,
      35,
      16.296048,
      43.773933,
      17.929413,
      27.843088,
      19.713358,
      21.807625,
      11.954121,
      26.326390,
      2.595643,
      36,
      NULL,
      40.179635,
      4,
      1.546677,
      155,
      NULL,
      55,
      174,
      16,
      174.104335,
      '11- 0-1975',
      NULL,
      59.455964,
      35,
      21.668512,
      77.696362,
      176.319977,
      ' 9- 2-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      87,
      17,
      15,
      NULL,
      2,
      2,
      ' 5-25-1985',
      NULL,
      0.335491,
      NULL,
      0.948599,
      1,
      NULL,
      3,
      NULL,
      18.606494,
      NULL,
      NULL,
      NULL,
      ' 3-28-1986',
      NULL,
      18.382857,
      29,
      NULL,
      77,
      83,
      47,
      16,
      13,
      51,
      64,
      NULL,
      ' 4-13-2000',
      NULL,
      18,
      5,
      22,
      NULL,
      132.541281,
      5,
      ' 1-19-1976',
      22,
      NULL,
      '11- 9-1995',
      NULL,
      10,
      8,
      16.706177,
      10.095537,
      9.275559,
      0,
      18,
      NULL,
      106,
      NULL,
      4,
      0,
      8,
      NULL,
      1.093535,
      0.898827,
      1.459982,
      ' 9- 9-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      35,
      7,
      '10- 3-1990',
      NULL,
      NULL,
      NULL,
      13,
      ' 1-23-1988',
      19,
      '11- 3-1992',
      5.620411,
      2,
      ' 3- 5-1995',
      NULL,
      17,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      10.629316,
      '10-27-1994',
      NULL,
      NULL,
      2.682701,
      ' 4-14-1976',
      NULL,
      129,
      NULL,
      14,
      4,
      20,
      5.252556,
      NULL,
      NULL,
      1.133167,
      NULL,
      ' 9-23-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


