set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9112150';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '0',
      '1',
      '3',
      '2',
      '0',
      '0',
      '0',
      '2',
      '3',
      NULL,
      '0',
      '2',
      '1',
      '3',
      '1',
      '3',
      NULL,
      '3',
      '2',
      NULL,
      '3',
      '2',
      '1',
      '',
      '0',
      NULL,
      NULL,
      '0',
      '2',
      '1',
      '4',
      '',
      '',
      NULL,
      '0',
      '2',
      NULL,
      NULL,
      '1',
      NULL,
      '2',
      '2',
      '3',
      '0',
      '021',
      '22144321',
      32.536723,
      NULL,
      '4243013',
      NULL,
      NULL,
      NULL,
      NULL,
      '123312',
      NULL,
      ' 8- 7-1983',
      NULL,
      22.798447,
      73.441892,
      NULL,
      4,
      NULL,
      15,
      30,
      NULL,
      NULL,
      18,
      40,
      23,
      34,
      21.517503,
      32.264718,
      2.864476,
      24,
      15,
      8,
      2,
      33.773644,
      NULL,
      4,
      6,
      1,
      NULL,
      116,
      23.815211,
      NULL,
      129,
      4.712069,
      ' 5-20-2002',
      27,
      34,
      32,
      38.911246,
      115.929081,
      116,
      ' 1-28-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      29.305031,
      6,
      14,
      13.940433,
      13,
      1.474070,
      ' 2-27-1983',
      NULL,
      1.099502,
      150,
      NULL,
      1,
      81.886671,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-26-1992',
      32.268110,
      26,
      NULL,
      26,
      35,
      NULL,
      63,
      53,
      NULL,
      NULL,
      58.486304,
      8.467757,
      ' 8-17-1993',
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      199.150813,
      12,
      ' 1- 5-1991',
      27.448918,
      2,
      ' 5-14-1989',
      2,
      1.493979,
      0.805766,
      NULL,
      15.256106,
      12.279637,
      1,
      19,
      1.065669,
      55.179901,
      4.910420,
      0.741465,
      4.650875,
      29,
      0,
      6,
      NULL,
      0,
      ' 3-13-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      69.197804,
      14,
      NULL,
      NULL,
      NULL,
      NULL,
      38,
      '11-15-1997',
      10.300580,
      ' 7-29-1992',
      0,
      7,
      ' 1-11-1995',
      23,
      30.202691,
      ' 1- 2-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      23.235194,
      ' 3-10-1990',
      7,
      4.244471,
      27.524148,
      ' 2-17-1989',
      NULL,
      77.963970,
      '11-20-1996',
      18.864215,
      NULL,
      NULL,
      53.630215,
      ' 9- 9-1997',
      29,
      1.502144,
      94.205810,
      ' 8-27-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


