set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9235817';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      '31211000',
      '03313144',
      NULL,
      '03000444',
      '44444403',
      '42221443',
      '11121111',
      '24032331',
      '42222220',
      '42013100',
      '03113003',
      '12140102',
      '34001131',
      '00023420',
      '24034001',
      '02200304',
      '04132420',
      '44141010',
      '40340044',
      '32344011',
      NULL,
      '01011141',
      '20422230',
      NULL,
      '31441102',
      '12203441',
      '32032331',
      '31133441',
      NULL,
      '14140121',
      '03000433',
      '41110412',
      '21204132',
      '44222212',
      NULL,
      NULL,
      '31243234',
      '04404413',
      '33313302',
      '02422202',
      NULL,
      NULL,
      '03143242',
      '411',
      '21',
      30.487767,
      7.885471,
      '4330434',
      NULL,
      1,
      NULL,
      NULL,
      '120030',
      4,
      ' 7-25-2001',
      ' 4- 8-1975',
      8.321580,
      33,
      40,
      NULL,
      0,
      24.040465,
      NULL,
      NULL,
      23.275811,
      NULL,
      32.026958,
      20,
      31.115252,
      11,
      22.199826,
      20,
      5.782162,
      11,
      NULL,
      NULL,
      30,
      16,
      64.695280,
      25.985083,
      1,
      81,
      106.252381,
      NULL,
      NULL,
      104,
      223,
      ' 6- 1-1982',
      NULL,
      31.084540,
      2,
      24,
      192,
      56.700744,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12,
      NULL,
      NULL,
      26,
      NULL,
      1.820882,
      ' 6-18-1987',
      1,
      1,
      92.604801,
      0,
      NULL,
      NULL,
      2.809807,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-29-1983',
      20,
      34.902314,
      6,
      50,
      39.363085,
      51,
      29,
      NULL,
      NULL,
      70.595504,
      81.424141,
      24.987600,
      ' 6-27-1988',
      19,
      29,
      3,
      NULL,
      77,
      8.744231,
      12.022348,
      ' 5-27-1978',
      6.916387,
      40.688842,
      ' 0-26-1987',
      NULL,
      3.252584,
      0,
      NULL,
      6,
      14,
      1,
      23.792559,
      0.906227,
      81,
      5.116219,
      2,
      13.800016,
      24.085101,
      0.630381,
      0.167006,
      0,
      0,
      ' 2-13-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      95,
      NULL,
      '11-21-1977',
      NULL,
      NULL,
      NULL,
      12.074777,
      ' 8-28-1988',
      NULL,
      NULL,
      5,
      0,
      ' 5-11-1987',
      5,
      108,
      ' 5-26-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      11,
      ' 4-24-2001',
      27.262470,
      32,
      NULL,
      ' 7-11-1994',
      0.486805,
      23,
      ' 8-28-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


