set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9221532';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      '30041411',
      '13214112',
      '14422012',
      '00023012',
      '34330433',
      '02311132',
      '40320223',
      '00421202',
      '13104003',
      '30140012',
      NULL,
      '30343404',
      '23010330',
      '14342303',
      '24422423',
      '42424403',
      '40340233',
      NULL,
      NULL,
      '32130224',
      '33013401',
      '21114300',
      '41402021',
      '40414410',
      NULL,
      '11313140',
      NULL,
      '34134100',
      '10030240',
      '11412330',
      NULL,
      NULL,
      '34102041',
      '41110341',
      '02131414',
      '43100343',
      '42014031',
      '04331021',
      NULL,
      '30130122',
      NULL,
      '21123103',
      '311',
      NULL,
      NULL,
      NULL,
      '3313302',
      1.490488,
      1.676962,
      2,
      NULL,
      '240310',
      3,
      NULL,
      ' 0- 0-2002',
      27.075265,
      NULL,
      1.238916,
      NULL,
      2,
      NULL,
      52,
      0.141814,
      14.705706,
      8.792481,
      NULL,
      NULL,
      34,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      48,
      24,
      43,
      15.904644,
      76,
      16.443976,
      0.766457,
      91,
      29.158012,
      92.903822,
      117.976288,
      53,
      NULL,
      ' 4-13-1985',
      24,
      1.890455,
      0,
      27.576981,
      224.277266,
      144.532955,
      ' 3- 5-1988',
      3,
      NULL,
      1,
      0,
      0,
      1,
      2,
      0,
      0.168707,
      0,
      1,
      1.006854,
      NULL,
      0.890589,
      0.219845,
      1.792788,
      0.063261,
      0.681614,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-14-2003',
      60.190762,
      20.346990,
      4,
      2.141419,
      NULL,
      3.305476,
      ' 5- 2-1993',
      0,
      3,
      185.479242,
      3,
      5,
      NULL,
      0,
      5,
      43,
      1,
      2.044075,
      23.837080,
      ' 8-10-1975',
      106.874793,
      82.887026,
      75.898126,
      111,
      9,
      56,
      35.826355,
      75.996924,
      81.977816,
      97.234804,
      NULL,
      NULL,
      '11-17-1983',
      17.067600,
      8,
      28.334305,
      81,
      5.832395,
      60,
      11.114124,
      ' 5-18-1992',
      1,
      14,
      ' 1-19-1975',
      11.269572,
      15.951703,
      8,
      14.037928,
      2.729564,
      12.266907,
      0,
      25.211521,
      0.840628,
      45.502887,
      1,
      NULL,
      0.710954,
      NULL,
      1,
      1,
      2,
      NULL,
      NULL,
      6.093371,
      0.381905,
      0,
      ' 4- 0-2000',
      192.771886,
      24,
      NULL,
      20.107987,
      30,
      ' 4-29-2000',
      47.583985,
      ' 8-12-2003',
      47.215732,
      ' 7-24-1999',
      4.603706,
      9.453303,
      '10- 4-1991',
      68,
      35.542029,
      ' 2- 1-1994',
      8.462094,
      12,
      ' 0-21-1997',
      2,
      4.181738,
      ' 2-24-1975',
      2,
      0,
      NULL,
      NULL,
      12.058009,
      28.342786,
      40,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13);
commit;
end;
/


