set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9629538';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0034',
      NULL,
      NULL,
      '33213133',
      NULL,
      '04411433',
      '13203321',
      '30143324',
      '12031034',
      '40044023',
      '14423414',
      '32321310',
      '04001420',
      '21021441',
      '10112040',
      '03431003',
      '12300433',
      '11123302',
      '12303001',
      '13012332',
      '00041013',
      '00201214',
      '42044223',
      '43314224',
      '42011442',
      '20030433',
      NULL,
      '31214424',
      '13123422',
      '12441214',
      '13320321',
      '20212131',
      NULL,
      '11341011',
      '21433231',
      NULL,
      NULL,
      NULL,
      '32000333',
      NULL,
      '21441121',
      '24401002',
      NULL,
      '30144131',
      '34022232',
      '122',
      '32',
      7.637436,
      5,
      NULL,
      2,
      0.715428,
      NULL,
      NULL,
      '422032',
      3,
      ' 9-25-2002',
      ' 9-15-2000',
      NULL,
      65.255116,
      17.675156,
      8.231125,
      NULL,
      NULL,
      2.075742,
      8.925334,
      17,
      8.009822,
      NULL,
      3.031017,
      15,
      27,
      12.012722,
      21,
      24,
      4.313432,
      36,
      2,
      51.898357,
      2.880899,
      98.831205,
      1.257583,
      1,
      93.307109,
      139,
      69,
      NULL,
      NULL,
      72,
      NULL,
      43,
      41.680916,
      3,
      24,
      131,
      61.917260,
      ' 8- 0-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      62.873887,
      8,
      11,
      3,
      11,
      9.423216,
      ' 6- 8-2000',
      1,
      NULL,
      29,
      NULL,
      1.213651,
      65,
      1,
      1.917530,
      54.338941,
      NULL,
      NULL,
      NULL,
      ' 3-21-1981',
      96,
      74.835838,
      68.942055,
      23.668920,
      74,
      NULL,
      NULL,
      47.936024,
      1,
      46,
      24,
      17,
      ' 4- 0-1985',
      NULL,
      17.139544,
      16.645643,
      26,
      35.958818,
      NULL,
      2,
      ' 0-23-1985',
      29,
      23,
      '11- 1-1979',
      0.445290,
      0,
      15,
      14,
      4.813190,
      2,
      0,
      14.836706,
      NULL,
      NULL,
      1.627992,
      1,
      10.627896,
      6,
      0,
      0.747693,
      3.912411,
      NULL,
      ' 7- 5-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      38,
      3.147727,
      NULL,
      NULL,
      NULL,
      NULL,
      46.952629,
      ' 0-23-1991',
      6.703460,
      ' 3-27-1995',
      6,
      4,
      '10-16-1999',
      1.052583,
      77.681359,
      ' 9- 7-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      10,
      ' 3-29-1982',
      44,
      10.425145,
      NULL,
      ' 4-12-1986',
      1.432454,
      101,
      ' 0- 5-1980',
      NULL,
      1.810053,
      NULL,
      0.907272,
      ' 3-18-1987',
      13,
      NULL,
      30,
      ' 4-21-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


