set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9115467';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4031',
      NULL,
      '23430222',
      '23414402',
      NULL,
      '34344210',
      '10111314',
      NULL,
      '00214413',
      '00420311',
      '11303333',
      '41013223',
      NULL,
      '32233343',
      NULL,
      '41401143',
      '04002042',
      NULL,
      '02223203',
      '11324032',
      '40123432',
      NULL,
      NULL,
      '24002320',
      '32232342',
      '43244110',
      NULL,
      NULL,
      '12312312',
      '14423331',
      NULL,
      '03104333',
      NULL,
      '22431341',
      '12011014',
      '10234340',
      '43243302',
      '10140313',
      NULL,
      '30314214',
      '24032014',
      NULL,
      '20311424',
      '12113313',
      '01030112',
      '',
      '',
      NULL,
      NULL,
      '1122101',
      NULL,
      NULL,
      NULL,
      NULL,
      '312012',
      1,
      ' 1- 9-1995',
      ' 4-29-1990',
      2,
      NULL,
      32,
      NULL,
      45.002293,
      NULL,
      NULL,
      7,
      4.576415,
      21.555114,
      26.482932,
      NULL,
      10.270761,
      0.560424,
      5.628005,
      13,
      4,
      5.406846,
      45,
      21,
      NULL,
      16.482678,
      NULL,
      1,
      NULL,
      27.022803,
      204,
      NULL,
      60,
      177.715451,
      11,
      ' 0-19-1997',
      33.253616,
      NULL,
      18.343261,
      16,
      NULL,
      NULL,
      ' 7-22-1982',
      NULL,
      1,
      0.302669,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0.545932,
      0,
      0.777299,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 5-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-26-1999',
      95.707307,
      114,
      90,
      98.041011,
      18.536969,
      25.452479,
      100,
      33,
      36,
      74.093292,
      64,
      109.138502,
      ' 3-21-1975',
      6.747411,
      9,
      8,
      4.884494,
      61.469134,
      78,
      8.308965,
      ' 0-11-1984',
      23,
      NULL,
      ' 9- 3-1980',
      3,
      11.186695,
      13,
      9.787010,
      8.739713,
      NULL,
      NULL,
      4,
      NULL,
      14.989021,
      5.814469,
      0,
      4.351667,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-29-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      52.924409,
      25,
      1,
      '11-12-1986',
      1,
      27.139297,
      ' 6-12-1977',
      19.655355,
      14.922365,
      21.764242,
      9.583226,
      ' 1-21-1977',
      13,
      NULL,
      11.328665,
      ' 4-12-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      38,
      NULL,
      NULL,
      84,
      43,
      18,
      10.778156,
      23,
      9,
      NULL,
      1.537531,
      1.317176,
      2,
      NULL,
      NULL,
      NULL,
      0,
      0,
      23,
      NULL,
      NULL,
      135.920767,
      NULL,
      15,
      NULL,
      0.757282,
      NULL,
      1,
      0.840148,
      1.333741,
      1,
      0,
      1.510470,
      NULL,
      NULL,
      NULL,
      13,
      NULL,
      NULL,
      0.419337,
      10.344082,
      NULL,
      1.324311,
      NULL,
      10.773183,
      55.185467,
      0,
      NULL,
      1.668300,
      NULL,
      0,
      0.921278,
      NULL,
      NULL,
      6.919850,
      24.767222,
      NULL,
      NULL,
      6,
      NULL,
      0,
      0.768479,
      4,
      NULL,
      2,
      NULL,
      1.850021,
      1.585292,
      NULL,
      '11-27-1990',
      NULL,
      ' 8- 2-1978',
      ' 6- 4-1978',
      NULL,
      NULL,
      ' 0-15-2002',
      NULL);
commit;
end;
/


