set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7921639';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2200',
      '13111334',
      '20312000',
      NULL,
      '42334020',
      NULL,
      '21342411',
      '21020142',
      '14310200',
      '40033024',
      '33130032',
      NULL,
      '03331303',
      '24324020',
      '12034333',
      '44240433',
      '02121240',
      '00230223',
      '30430300',
      '11112412',
      '04131333',
      '22342333',
      '20213030',
      '32301024',
      '04100402',
      '42140311',
      '12212324',
      '14030004',
      '12003333',
      '14422443',
      '33412220',
      '23242020',
      '12202401',
      '10013442',
      '21344433',
      '34211034',
      '41014144',
      NULL,
      '43043120',
      '41144310',
      '22221320',
      '44230400',
      '30001003',
      '01412431',
      NULL,
      '412',
      '32',
      23,
      4,
      '2241100',
      3.005957,
      1,
      NULL,
      NULL,
      '044321',
      2,
      ' 2-16-1984',
      NULL,
      63,
      26,
      4.835729,
      NULL,
      NULL,
      12,
      89.859560,
      17.258592,
      NULL,
      NULL,
      5,
      3.452195,
      NULL,
      23.865785,
      NULL,
      14.883135,
      19,
      9,
      4,
      NULL,
      51.354841,
      NULL,
      NULL,
      3.618794,
      NULL,
      124,
      NULL,
      110.336758,
      207,
      NULL,
      NULL,
      ' 6-28-1974',
      45.537676,
      10,
      12.388117,
      2.617797,
      124,
      116,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.407974,
      15,
      8.619550,
      9.360559,
      ' 8- 8-1987',
      1.658148,
      NULL,
      40,
      0,
      NULL,
      35.292819,
      2,
      6,
      28,
      NULL,
      NULL,
      NULL,
      ' 7-20-2001',
      NULL,
      NULL,
      80.161698,
      55,
      41,
      NULL,
      53,
      66.187157,
      74.871352,
      57,
      33,
      26.343635,
      ' 5-26-1997',
      10.163542,
      15.482094,
      0.167438,
      37,
      35,
      NULL,
      1.484315,
      ' 7- 7-1974',
      NULL,
      18,
      NULL,
      NULL,
      0.904764,
      22,
      8,
      14,
      6.573408,
      NULL,
      NULL,
      0.426769,
      86,
      0,
      0.780026,
      8.210845,
      15.946545,
      1.958684,
      1.099570,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      129,
      7.835210,
      ' 8- 6-2002',
      NULL,
      NULL,
      NULL,
      16,
      ' 3-29-2001',
      NULL,
      ' 6- 8-1998',
      9.692483,
      NULL,
      ' 3-26-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      '10-28-1990',
      18,
      38,
      23,
      NULL,
      1.184696,
      38.713005,
      ' 6-28-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


