set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7921639';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      '2',
      '4',
      '1',
      NULL,
      '0',
      '0',
      NULL,
      '1',
      '2',
      '1',
      '2',
      '3',
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '1',
      '2',
      NULL,
      '1',
      '0',
      '',
      NULL,
      '',
      NULL,
      NULL,
      '3',
      NULL,
      '1',
      '',
      '',
      '1',
      '3',
      '4',
      '4',
      '4',
      '0',
      '1',
      NULL,
      '0',
      '4',
      '4',
      '231',
      '30420123',
      NULL,
      34.114081,
      '0444404',
      3,
      NULL,
      0,
      0,
      '444124',
      2,
      ' 8- 1-1984',
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      20.163470,
      17.216424,
      36,
      10,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      62.167710,
      2.943685,
      NULL,
      NULL,
      51.749435,
      11.978345,
      3.179356,
      89.706061,
      47,
      NULL,
      32,
      9.016468,
      NULL,
      ' 5-13-1987',
      25,
      31,
      22,
      11.671678,
      201.940431,
      59.989589,
      ' 4- 7-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      3.604303,
      18.778278,
      65.845583,
      13.894820,
      0,
      NULL,
      NULL,
      3.832486,
      NULL,
      NULL,
      0.097391,
      14.668061,
      0,
      2.349866,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      21,
      83,
      42.758963,
      88,
      NULL,
      26,
      25.666881,
      62.810463,
      21,
      38.750788,
      88,
      25.278433,
      '11-27-1997',
      1,
      19.184702,
      NULL,
      52.424422,
      58,
      122.140520,
      4.789172,
      ' 5- 4-1999',
      17.818876,
      2.961864,
      '10- 2-1988',
      NULL,
      10,
      17,
      20,
      9.530547,
      10.489038,
      1.465009,
      0,
      NULL,
      NULL,
      2.689787,
      1,
      19,
      NULL,
      1,
      3,
      1,
      1.816643,
      ' 2-28-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15.865473,
      ' 2-28-1992',
      53.342031,
      ' 6-23-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      ' 0- 7-1978',
      43.473928,
      17,
      NULL,
      ' 6- 1-2000',
      1.088036,
      83,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


