set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9825803';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '3',
      '4',
      '0',
      NULL,
      NULL,
      '2',
      '2',
      '0',
      '0',
      '1',
      '4',
      NULL,
      '0',
      '0',
      '0',
      '4',
      '1',
      NULL,
      '3',
      '0',
      '2',
      NULL,
      '2',
      '',
      '0',
      '',
      '0',
      '1',
      '4',
      '4',
      NULL,
      NULL,
      '',
      NULL,
      '2',
      '4',
      '4',
      '4',
      '1',
      NULL,
      '2',
      '1',
      '2',
      '2',
      '242',
      '33202423',
      3.724515,
      60.052552,
      '3240044',
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-26-1976',
      NULL,
      261.566224,
      NULL,
      18,
      17,
      21,
      6.724874,
      NULL,
      NULL,
      3,
      20,
      3,
      NULL,
      NULL,
      NULL,
      20,
      NULL,
      1.735060,
      1.914767,
      0,
      5,
      27,
      3.758607,
      NULL,
      3,
      1.313541,
      56,
      NULL,
      33,
      144,
      NULL,
      NULL,
      NULL,
      NULL,
      54,
      6.412765,
      33,
      201,
      NULL,
      ' 6-23-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      45.238270,
      0,
      7,
      7,
      NULL,
      1,
      ' 4-16-1996',
      1.194851,
      0.055986,
      0,
      0.827268,
      NULL,
      125,
      NULL,
      NULL,
      66.964154,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      21.938522,
      128,
      107.201786,
      36,
      50,
      19.292184,
      42,
      141,
      74,
      NULL,
      ' 8- 7-1987',
      36.620265,
      1,
      29,
      91,
      6.605882,
      182,
      9.671714,
      ' 2-17-1991',
      20.901179,
      15.034943,
      ' 7-26-1989',
      NULL,
      1.868886,
      0.141717,
      21,
      27.958478,
      9,
      1.559557,
      17,
      1,
      40,
      1.407324,
      1.486664,
      13.483319,
      4.302158,
      3.175073,
      0.264775,
      1,
      1,
      ' 9- 2-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      161,
      5.171111,
      ' 6-21-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10.214727,
      ' 4-17-1982',
      21.728383,
      11.865856,
      ' 1- 3-1982',
      126.601199,
      94,
      '10-16-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      NULL,
      63.656696,
      31,
      25,
      ' 3- 5-1997',
      1,
      7,
      ' 6- 3-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


