set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8530978';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4303',
      '03043131',
      '42243232',
      '42004221',
      '12241011',
      NULL,
      '32030022',
      '11421142',
      '04242142',
      NULL,
      '22042420',
      '33122041',
      NULL,
      NULL,
      '33044430',
      '44431334',
      '02114410',
      '01203033',
      NULL,
      NULL,
      NULL,
      '21204041',
      '31103303',
      NULL,
      '20210130',
      '20110222',
      '00324123',
      '34303430',
      '33241204',
      '34210132',
      '30412234',
      '41113323',
      '33214240',
      '10123102',
      '34214223',
      '14321341',
      '22343134',
      '32212423',
      '32210042',
      '00001122',
      NULL,
      '34431300',
      '22131124',
      '00102221',
      NULL,
      '202',
      '43',
      NULL,
      NULL,
      '4322113',
      1,
      1.386566,
      2,
      NULL,
      '222444',
      5.002861,
      ' 4-26-2001',
      '11-24-1990',
      51.237359,
      NULL,
      23.447616,
      11.443278,
      9,
      8.519517,
      19.114814,
      21,
      18.648040,
      NULL,
      39,
      25,
      37.429150,
      15.150248,
      6,
      1,
      15,
      6.091126,
      37.706527,
      NULL,
      19.740256,
      NULL,
      29.983897,
      24.472793,
      NULL,
      32,
      191,
      NULL,
      76.950961,
      NULL,
      195.850248,
      '11-22-1978',
      37.354248,
      52,
      NULL,
      28.369895,
      78,
      58.312644,
      NULL,
      1.789716,
      3,
      0,
      NULL,
      1.800361,
      2.682585,
      1,
      1.098914,
      0.092425,
      NULL,
      NULL,
      0,
      1.570804,
      2,
      1.646700,
      0.813160,
      5.966436,
      0.615883,
      1.584334,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 7-2003',
      NULL,
      6.838811,
      NULL,
      9.921572,
      7.124862,
      10,
      NULL,
      NULL,
      NULL,
      30,
      0,
      1.745606,
      46,
      NULL,
      0.833009,
      5,
      1.940939,
      0,
      71,
      '11- 8-2001',
      92.132166,
      34.856503,
      NULL,
      51.766623,
      9,
      80,
      68,
      NULL,
      9,
      62,
      42,
      36,
      ' 6-14-1985',
      NULL,
      19.846800,
      17.792287,
      49.652380,
      79,
      74,
      11.365145,
      ' 9-23-1977',
      NULL,
      7,
      NULL,
      NULL,
      14.602449,
      19,
      14,
      3,
      8,
      1.561134,
      NULL,
      0,
      125,
      0,
      NULL,
      9,
      22,
      0,
      NULL,
      0.096575,
      0.029839,
      ' 0-25-1998',
      3.337948,
      3,
      3,
      ' 2-19-2000',
      NULL,
      10.491790,
      '10- 6-1978',
      NULL,
      6,
      ' 9- 4-1986',
      7,
      ' 4- 8-1996',
      NULL,
      ' 9-13-1998',
      13,
      NULL,
      ' 3-28-1986',
      NULL,
      104.556002,
      ' 9-22-1977',
      NULL,
      10,
      ' 6-24-1983',
      2.211481,
      1.860614,
      NULL,
      0,
      0,
      NULL,
      ' 8-26-1996',
      51.966726,
      NULL,
      NULL,
      '11-12-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4);
commit;
end;
/


