set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9734093';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      NULL,
      '2',
      '2',
      NULL,
      NULL,
      '3',
      '2',
      NULL,
      '3',
      '2',
      '0',
      NULL,
      NULL,
      '3',
      '2',
      '2',
      '0',
      '2',
      '2',
      '3',
      '0',
      '1',
      '1',
      '',
      '4',
      '',
      '3',
      '1',
      NULL,
      '0',
      '3',
      '',
      '',
      '1',
      NULL,
      '0',
      '0',
      '2',
      '0',
      '3',
      '3',
      '3',
      '4',
      '0',
      '412',
      '00042102',
      10,
      NULL,
      '2111431',
      3,
      1.557323,
      0,
      0,
      '303343',
      3,
      ' 0-19-2003',
      ' 3-17-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      28,
      16,
      92,
      17,
      11,
      25,
      10.876267,
      NULL,
      39.228979,
      2,
      24,
      4.616649,
      12,
      11,
      22.603674,
      NULL,
      48.227250,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      163,
      107,
      168,
      246,
      95.747729,
      ' 1-19-1998',
      10.524178,
      NULL,
      4,
      0.265509,
      136,
      22,
      ' 9-14-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      58.947135,
      20,
      0.716498,
      8,
      8,
      1.565818,
      ' 5- 6-1990',
      1,
      0,
      168,
      1.757120,
      0.356976,
      63.638093,
      2,
      NULL,
      70,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15.067922,
      23.686452,
      NULL,
      54.721896,
      73.009499,
      2.605518,
      63,
      68,
      71.980916,
      31.233310,
      75.727103,
      ' 2- 4-1993',
      22,
      3.138543,
      2.526048,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-11-1986',
      27,
      13,
      ' 8-25-1977',
      0.795868,
      NULL,
      NULL,
      NULL,
      14,
      0.327624,
      1,
      5,
      0,
      75,
      3,
      6.875139,
      NULL,
      3.162835,
      0,
      0,
      0,
      0,
      ' 1-21-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      207,
      NULL,
      ' 2-17-1996',
      NULL,
      NULL,
      NULL,
      32.170207,
      '10- 5-1980',
      NULL,
      ' 0-24-1996',
      4.338299,
      5,
      NULL,
      97,
      14.633782,
      ' 6-14-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      5.914437,
      ' 4- 6-1986',
      NULL,
      36.551992,
      9.324857,
      NULL,
      NULL,
      5,
      ' 4- 8-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


