set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8727701';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3433',
      '14001332',
      '12334044',
      '44140134',
      '34413442',
      '31424230',
      '33414313',
      '04400033',
      NULL,
      '21123241',
      '42424403',
      '40114414',
      '11123233',
      '40411104',
      '32311401',
      '00044201',
      NULL,
      '41403044',
      NULL,
      NULL,
      NULL,
      '32302334',
      NULL,
      '01430232',
      '01220221',
      '34400032',
      NULL,
      '00133321',
      '44234434',
      '30041224',
      NULL,
      '32044212',
      NULL,
      '33421001',
      '03442012',
      '22401141',
      NULL,
      '23413130',
      '12323221',
      '33023213',
      '01303422',
      '31032212',
      NULL,
      NULL,
      '04204103',
      '',
      '',
      NULL,
      NULL,
      '3100400',
      0,
      0.187016,
      0,
      NULL,
      '314301',
      3,
      ' 0-11-1982',
      ' 1- 2-1978',
      19.384211,
      NULL,
      15,
      2.879078,
      NULL,
      NULL,
      22,
      0.552008,
      8.762961,
      1,
      1.071459,
      4.120448,
      NULL,
      6.749857,
      10,
      NULL,
      6,
      15.992536,
      16.692918,
      12,
      40.169199,
      13.608255,
      58.252933,
      9,
      NULL,
      10,
      76.937040,
      63.217511,
      42,
      NULL,
      145,
      ' 3-14-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.273973,
      2.106613,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.281490,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-19-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      71,
      63,
      11,
      NULL,
      47,
      NULL,
      64.485571,
      84,
      NULL,
      86,
      NULL,
      17,
      ' 8- 1-1988',
      3.759442,
      1,
      4,
      65,
      23,
      7.490712,
      3,
      '10-11-1993',
      NULL,
      2.508854,
      ' 8-19-1978',
      0,
      3,
      NULL,
      9,
      13,
      6,
      NULL,
      3.183580,
      NULL,
      NULL,
      0.529544,
      1.907416,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1- 5-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      40,
      NULL,
      20,
      ' 0-18-1991',
      NULL,
      NULL,
      ' 0-15-1998',
      1.795052,
      67,
      8.773510,
      48,
      NULL,
      27.799373,
      3,
      66,
      '11-26-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      31.283464,
      49,
      81,
      93.880674,
      45.528543,
      NULL,
      NULL,
      13.930066,
      NULL,
      NULL,
      NULL,
      0.722566,
      1.550561,
      NULL,
      NULL,
      0.892938,
      NULL,
      4.476812,
      0,
      NULL,
      27.869388,
      5,
      9,
      30.499638,
      NULL,
      74.047580,
      0.215509,
      86.980995,
      4.320301,
      0.632856,
      1.546571,
      0,
      2,
      1.560394,
      59,
      63,
      NULL,
      15,
      73.083242,
      79,
      1,
      0,
      8,
      NULL,
      NULL,
      0,
      13,
      0.839377,
      NULL,
      0.888457,
      100,
      0.447335,
      NULL,
      31.897869,
      20,
      NULL,
      9.719723,
      102.933752,
      115,
      4,
      NULL,
      5,
      NULL,
      1,
      4,
      1.736125,
      0,
      1.651262,
      0.479774,
      56,
      ' 3-28-1989',
      ' 0-13-1989',
      ' 3-29-1994',
      NULL,
      ' 8- 9-1981',
      ' 6-14-1988',
      NULL,
      NULL);
commit;
end;
/


