set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8727701';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0340',
      '01440343',
      '13031433',
      '03141430',
      '30213244',
      '12240120',
      '00140404',
      NULL,
      '13040231',
      '32030103',
      '31013000',
      '21224112',
      '02014443',
      '02444424',
      '44422224',
      '44410001',
      NULL,
      '43342312',
      '44441111',
      '11404212',
      '04304304',
      '41023332',
      '34300241',
      '11324403',
      '34442001',
      '21402012',
      '21310203',
      '03332113',
      '00130233',
      '21221221',
      '24111133',
      NULL,
      '04134224',
      '12441101',
      '13423012',
      '22210040',
      '30303023',
      '21204440',
      '10234244',
      NULL,
      '20024440',
      '02022400',
      NULL,
      '04214042',
      '31331141',
      '',
      '',
      NULL,
      NULL,
      '2022331',
      3,
      35.129614,
      3,
      NULL,
      '032332',
      NULL,
      ' 4-13-1996',
      ' 0-10-1999',
      40.912549,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15.384439,
      22,
      NULL,
      30,
      117.790706,
      36.344694,
      ' 0-25-1993',
      1,
      NULL,
      7.183959,
      2.710059,
      NULL,
      NULL,
      NULL,
      NULL,
      1.637160,
      0.518063,
      5,
      NULL,
      NULL,
      0.789591,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-23-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-29-1994',
      NULL,
      NULL,
      26,
      142.719790,
      NULL,
      104,
      91,
      150,
      108,
      4.857312,
      66,
      125.471195,
      ' 0-29-1999',
      NULL,
      5,
      NULL,
      38.911402,
      13,
      39,
      11,
      ' 1-11-1989',
      5.702477,
      NULL,
      ' 6-10-1999',
      0.493289,
      11.815223,
      NULL,
      5.857770,
      27.343835,
      NULL,
      NULL,
      NULL,
      NULL,
      102,
      0,
      64.627700,
      19.814967,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      114,
      34.033975,
      34.382252,
      56.041213,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.155046,
      35,
      0.483809,
      1.137304,
      8,
      0.701881,
      3.180321,
      103.676573,
      NULL,
      4.448359,
      184,
      107.447688,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.637467,
      0,
      10,
      1,
      0,
      1,
      7,
      NULL,
      0,
      1,
      54,
      1,
      0,
      107,
      11.820027,
      NULL,
      12,
      18,
      NULL,
      NULL,
      NULL,
      8.914981,
      5.527856,
      NULL,
      NULL,
      NULL,
      NULL,
      1.600759,
      0.685557,
      18.433782,
      NULL,
      NULL,
      NULL,
      ' 4-18-1974',
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


