set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8727701';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1202',
      '03312400',
      '31023004',
      NULL,
      '34002011',
      NULL,
      '21012344',
      '23404342',
      '04221001',
      '34000043',
      '23110001',
      '10401310',
      NULL,
      '04013031',
      '04320142',
      '44344214',
      '11114430',
      '34233240',
      '00303010',
      '13032410',
      NULL,
      NULL,
      '00314333',
      NULL,
      '40123432',
      '14030441',
      '03244043',
      '12403311',
      '14202013',
      '33440322',
      '00243021',
      '23132413',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '40401323',
      '31342201',
      '40220341',
      '43302120',
      '14221124',
      '34414141',
      '32320330',
      '42342213',
      '',
      '',
      NULL,
      NULL,
      '4431212',
      2,
      0.338748,
      3,
      NULL,
      '303100',
      NULL,
      ' 4- 9-1981',
      '11-16-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      43.706071,
      11.321262,
      11,
      24.962673,
      139.088763,
      NULL,
      NULL,
      3,
      1.327363,
      8,
      0.898534,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.300025,
      2.161252,
      1,
      1.591167,
      2.310373,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-19-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-20-1979',
      65.977391,
      115.247660,
      37.000839,
      26.319081,
      134,
      66.886930,
      24.923037,
      NULL,
      20,
      NULL,
      NULL,
      0,
      ' 1- 3-1990',
      10,
      5.261749,
      12.085146,
      0,
      1.961875,
      72,
      11,
      ' 7-29-2001',
      23,
      NULL,
      '11- 1-1993',
      3.292810,
      8,
      12.075143,
      18,
      24,
      2,
      NULL,
      20,
      NULL,
      45,
      1.533264,
      13.735681,
      6.221118,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 0-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      81.324651,
      NULL,
      26.042364,
      101,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.777751,
      53.570202,
      0.453034,
      4,
      66.340922,
      0,
      3,
      9,
      0.210780,
      5,
      63,
      NULL,
      NULL,
      NULL,
      NULL,
      15,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      23.243267,
      NULL,
      NULL,
      NULL,
      82.327371,
      NULL,
      1.330925,
      19,
      1.757277,
      1,
      NULL,
      16,
      0,
      27,
      6,
      43,
      1.833181,
      0,
      64.542555,
      25,
      0.808026,
      NULL,
      26.735373,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      4.011914,
      NULL,
      0,
      0.360828,
      2.737966,
      110,
      NULL,
      NULL,
      NULL,
      ' 1-23-1995',
      ' 9-14-1994',
      NULL,
      ' 6-19-1983',
      NULL);
commit;
end;
/


