set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8828342';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2403',
      '33234343',
      '33341244',
      '03144322',
      '34310010',
      '42314134',
      '01431140',
      '21000214',
      NULL,
      '41142144',
      NULL,
      NULL,
      '11021202',
      NULL,
      '13043023',
      '40211400',
      '11402222',
      '31031112',
      '03330431',
      '24343223',
      '11441424',
      '20043211',
      NULL,
      '11342243',
      '02044212',
      '13443042',
      '24004043',
      '22412130',
      '41133323',
      NULL,
      '40230203',
      NULL,
      '02203243',
      NULL,
      '43020424',
      '20444422',
      '40244314',
      '14000342',
      '21102210',
      '22003003',
      NULL,
      '11223040',
      NULL,
      '13422431',
      '14313432',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      '043341',
      2.206774,
      ' 7-12-1983',
      ' 6-25-1998',
      7.043720,
      NULL,
      42,
      7.719633,
      NULL,
      NULL,
      NULL,
      16,
      NULL,
      9.477285,
      36,
      1.609271,
      27.161298,
      1.161843,
      8.969377,
      2.818919,
      11.472198,
      8.590527,
      NULL,
      3,
      18.919893,
      NULL,
      10,
      NULL,
      NULL,
      1,
      20,
      84,
      145,
      69,
      NULL,
      ' 9-15-1994',
      8,
      37.366151,
      42,
      NULL,
      182,
      194.564450,
      NULL,
      5,
      6,
      7,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.283016,
      3.765128,
      1.971006,
      0.982442,
      1.108827,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1- 7-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10- 8-1977',
      NULL,
      64,
      33.958728,
      30,
      63.291851,
      67.825094,
      44,
      19,
      69.848138,
      8.430072,
      70,
      20,
      ' 5- 2-1997',
      21.175178,
      15.784418,
      2,
      57,
      56,
      31.037878,
      2,
      ' 4-14-1979',
      NULL,
      5,
      NULL,
      11,
      7.986017,
      6.188232,
      18.701133,
      6,
      12,
      NULL,
      20.094127,
      NULL,
      33,
      4,
      NULL,
      12.137051,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      46.916850,
      4,
      5.415204,
      ' 5-18-1997',
      0,
      61,
      ' 3- 2-1994',
      8,
      34.013996,
      13.308140,
      NULL,
      ' 4-14-1974',
      46.233325,
      NULL,
      51.417928,
      ' 7-16-1996',
      NULL,
      NULL,
      NULL,
      105.181222,
      20,
      NULL,
      62,
      65,
      58,
      1,
      12,
      11,
      10,
      9,
      113.975567,
      1,
      1.507654,
      84,
      NULL,
      NULL,
      NULL,
      4.466380,
      5,
      85.359489,
      0,
      NULL,
      19.133673,
      42,
      8,
      20.475305,
      1,
      NULL,
      1,
      1,
      1,
      5,
      1.804169,
      0.207351,
      101,
      44.386485,
      NULL,
      19.992488,
      NULL,
      32,
      0.616355,
      9,
      24.859219,
      1.166602,
      4.389862,
      NULL,
      3.863642,
      14.936992,
      89.582113,
      1,
      NULL,
      0.295348,
      0,
      7,
      14.987391,
      8,
      18.518762,
      62.648999,
      122.167654,
      NULL,
      NULL,
      9,
      2.759302,
      1,
      4.857967,
      5,
      5,
      0,
      0.995390,
      NULL,
      NULL,
      NULL,
      ' 1- 2-1991',
      NULL,
      ' 7-10-1987',
      ' 2- 3-1996',
      '11- 2-1989',
      NULL);
commit;
end;
/


